/*============================================
//薼FGLCD
//t@CFnokia_lcd.c
//tF2012/03/17
//OFKK
//
//NbN:48MHz (8MHz PLL/2)
//gpPICFPIC18F2550
//gpRpCFMPLAB C18 Compiler
============================================*/
#include <p18cxxx.h>

#include <usart.h>
#include <i2c.h>
#include <delays.h>
#include <stdio.h>

#include "i2c_eep_my.h"
#include "glcd_my.h"

/*=====RtBO[Vݒ=====*/
#pragma config PLLDIV = 2,CPUDIV = OSC1_PLL2,FOSC = HSPLL_HS,FCMEN = OFF,IESO = OFF
#pragma config PWRT = ON,BOR = OFF,BORV = 0,WDT = OFF,WDTPS = 1
#pragma config MCLRE = ON
#pragma config STVREN = ON,LVP = OFF,DEBUG = OFF
#pragma config CP0 = OFF,CP1 = OFF,CPB = OFF,CPD = OFF
#pragma config WRT0 = OFF,WRT1 = OFF
#pragma config WRTB = OFF,WRTC = OFF,WRTD = OFF
#pragma config EBTR0 = OFF,EBTR1 = OFF,EBTRB = OFF

/*=====֐`=====*/
void init(void);

/*=====O[oϐ錾=====*/
const unsigned int c_color[] = {
	RED,GREEN,BLUE,CYAN,MAGENTA,YELLOW,LIGHTGREEN,PINK,ORANGE,BROWN,NAVY,PURPLE,GRAY,DARKGRAY,BLACK,WHITE
};	

/*=====C֐=====*/
void main(void)
{
	unsigned int i,j;

	init();
	GLCD_Init();

	GLCD_Clear(WHITE);
	
	GLCD_Pixel(10,10,RED);
	GLCD_Pixel(121,121,GREEN);
	GLCD_Pixel(10,121,BLUE);
	GLCD_Pixel(121,10,YELLOW);
	
	GLCD_Line(20,20,111,111,ORANGE);
	GLCD_Line(20,111,111,20,CYAN);
	
	GLCD_Rect(20,40,40,60,MAGENTA);
	GLCD_RectFull(81,81,101,101,BROWN);
	
	GLCD_Circle(60,20,10,GREEN);
	
	for (i = 0x02 ; i <= 0x0D ; i++){
		for (j = 0x00 ; j <= 0x0F ; j++){
			GLCD_Character(j , i - 0x02 , (i << 4) | j , BLUE,YELLOW);
		}
	}		
	while (1){
//		for (i = 0 ; i < 16 ; i++){
//			GLCD_RectFull(91,91,111,111,c_color[i]);
//			Delay_ms(1000);
//		}
		
	}	
}
	
/*=====PICݒ=====*/
void init(void)
{
	ADCON1 = 0x0F;
	
	TRISA = 0x00;
	TRISB = 0xFF;
	
	TRISCbits.RC6 = 0;
	TRISCbits.RC7 = 1;
	/*9600*/
	OpenUSART(
		USART_TX_INT_OFF &
		USART_RX_INT_OFF &
		USART_ASYNCH_MODE &
		USART_EIGHT_BIT &
		USART_CONT_RX &
		USART_BRGH_LOW,
		77
	);
	
	OpenI2C(MASTER,SLEW_ON);
	SSPADD = 24;
}

