#ifndef __SWI2C16_H
#define __SWI2C16_H
/******************************************************************************
 // *                   SW_I2C PERIPHERAL LIBRARY HEADER FILE
 ******************************************************************************
 * FileName:        		sw_i2c.h
 * Dependencies:    	See include below
 * Processor:       		PIC18
 * Compiler:        		MCC18
 * Company:         		Microchip Technology, Inc.
 *****************************************************************************/
#include <pconfig.h>


/*gpʐMx̃Rg*/
//#define		SPEED_100K	/*100kbps*/
#define		SPEED_400K	/*400kbps*/


// USER NEEDS TO DEFINE DATA AND CLOCK PINS. RESISTORS ARE REQUIRED ON 
// DATA AND CLOCK PINS. 

/*DATAsݒ*/
#define  DATA_LOW   TRISAbits.TRISA0 = 0; // define macro for data pin output
#define  DATA_HI    TRISAbits.TRISA0 = 1; // define macro for data pin input
#define  DATA_LAT   LATAbits.LATA0        // define macro for data pin latch
#define  DATA_PIN   PORTAbits.RA0         // define macro for data pin

/*CLKsݒ*/
#define  CLOCK_LOW  TRISAbits.TRISA1 = 0; // define macro for clock pin output
#define  CLOCK_HI   TRISAbits.TRISA1 = 1; // define macro for clock pin input
#define  SCLK_LAT   LATAbits.LATA1        // define macro for clock pin latch
#define  SCLK_PIN   PORTAbits.RA1         // define macro for clock pin


/*****   FUNCTION PROTOTYPES FOR PIC18CXXX   *****/
void SWStopI2C ( void );
void SWStartI2C ( void );
void SWRestartI2C ( void );
void SWStopI2C ( void );

signed char SWAckI2C( void );
signed char Clock_test( void );
unsigned int SWReadI2C( void );
signed char SWWriteI2C( auto unsigned char data_out );
signed char SWGetsI2C( auto unsigned char *rdptr, auto unsigned char length );
signed char SWPutsI2C( auto unsigned char *wrptr );

/**************************************************************************
Macro       : SWPutcI2C

Description : macro is identical to SWWriteI2C,#define to SWWriteI2C in sw_i2c.h
 
Arguments   : None
 
Remarks     : None 
***************************************************************************/
#define  SWPutcI2C    SWWriteI2C

/**************************************************************************
Macro       : SWGetcI2C

Description : macro is identical to SWReadI2C,#define to SWReadI2C in sw_i2c.h
 
Arguments   : None
 
Remarks     : None 
***************************************************************************/
#define  SWGetcI2C    SWReadI2C

/**************************************************************************
Macro       : SWNotAckI2C

Description : macro is identical to SWAckI2C,#define to SWAckI2C in sw_i2c.h
 
Arguments   : None
 
Remarks     : None 
***************************************************************************/
#define  SWNotAckI2C  SWAckI2C

#endif
