
#ifndef HK_MULTICONFIG_H_
#define HK_MULTICONFIG_H_

#include <avr/io.h>
#include <avr/interrupt.h>
#include "system.h"

//|[g`
#define PIN_LED PB6
#define PIN_AIL PD1	//PCINT17
#define PIN_ELE PD2	//INT0
#define PIN_THR PD3	//INT1
#define PIN_RUD PB7	//PCINT7
#define PIN_M6  PD5
#define PIN_M5  PD6
#define PIN_M4  PD7
#define PIN_M3  PB0
#define PIN_M2  PB1
#define PIN_M1  PB2
#define PIN_GYR_ROL PC2
#define PIN_GYR_PIT PC1
#define PIN_GYR_YAW PC0
#define PIN_POT_YAW PC5
#define PIN_POT_PIT PC4
#define PIN_POT_ROL PC3

//IO𑽏֗ɂ
#define LED_ON() (PORTB |= (1 << PIN_LED))
#define LED_OFF() (PORTB &= ~(1 << PIN_LED))
#define PORTB_MASK ((1 << PIN_M1) | (1 << PIN_M2) | (1 << PIN_M3))
#define PORTD_MASK ((1 << PIN_M4) | (1 << PIN_M5) | (1 << PIN_M6))

//WRPWM̒Sl[us]
#define RX_CENTER (1520)
//WRPWM̍ŏl[us]
#define RX_MIN (1020)

//XbgŏɂȂĂƔfXbVh
#define RX_THR_THR (180)
//_[őɂȂĂƔfXbVh
#define RX_YAW_THR (350)

//o͂̃CjVCY
void initBoardIo(void);

//\tgEFAPWM֌W̃CjVCY
void initSoftPwm(void);

//M@̐M󂯎֌W̃CjVCY
void initRxInt(void);

//ʑ҂[ms]
volatile void wait(uint16_t);

//PWMo͊Jn@̊֐sĂ1[ms]ȓendPwmsKv
volatile void startPwm(void);

//PWMo͏I@startPwmsĂ1[ms]ȓɎsKv
//Ŗ1[ms]炢ʑ҂
//g̓AZu֐ softPwm.s
volatile void endPwm(uint8_t,uint8_t,uint8_t,uint8_t);

//o͂łPWM0`256ŁA0`1023Ȃ̂łȂ悤ɃXP[O
volatile void scalePwm(int16_t*,int16_t*,int16_t*,int16_t*);

//M@̐M󂯎[us]
volatile void getRx(uint16_t*,uint16_t*P,uint16_t*,uint16_t*);

#endif /* HK_MULTICONFIG_H_ */