/**
 ******************************************************************************
 * @file	STOyyb.h
 * @author	strv
 * @brief	STOyybp錾W
 ******************************************************************************
 */

#ifndef __STOYYB_H
#define __STOYYB_H

#include <stdint.h>

#define	SYSCLK_FREQ_72MHz

/* Functions ------------------------------------------------------------------*/


/* Macros ------------------------------------------------------------------*/
#define SYSTIMER_TICK_INTERVAL_HZ (1000)   //TimerCountUp֐Ă΂[HZ]
//#define SYSTIMER_USE_64BIT                 //TimervZ64bitgۂDŏZD64bitvZȂꍇ́CRgAEgD

//=======================================================
//#define SW_POLARITY_REVERSE
#define	SW_PORT						GPIOA
#define	SW_RCC						RCC_APB2Periph_GPIOA
#define	SW_PIN						GPIO_Pin_0
#define	SW_PORTSOURCE				GPIO_PortSourceGPIOA
#define	SW_PINSOURCE				GPIO_PinSource0
#define	SW_EXTI_LINE				EXTI_Line0
#define	SW_EXTI_IRQn				EXTI15_0_IRQn
#define	SW_EXTI_NUM					0

#define LED_POLARITY_REVERSE
#define	LED_PORT					GPIOB
#define	LED_RCC						RCC_APB2Periph_GPIOB
#define	LED1_PIN					GPIO_Pin_5
#define	LED2_PIN					GPIO_Pin_4

//=======================================================
#define USB_DIRECT_PU
#define	USB_DISCONNECT                  GPIOA
#define	USB_DISCONNECT_PIN              GPIO_Pin_8
#define	RCC_APB2Periph_GPIO_DISCONNECT  RCC_APB2Periph_GPIOA
#define	USB_DISCONNECT_POLARITY_REVERSE

//=======================================================

#define USART1_PORT                     GPIOA
#define USART1_RCC                      RCC_APB2Periph_USART1
#define USART1_GPIO_RCC                 RCC_APB2Periph_GPIOA
#define USART1_CK_PIN                   GPIO_Pin_8
#define USART1_TX_PIN                   GPIO_Pin_9
#define USART1_RX_PIN                   GPIO_Pin_10
//#define REMAP_USART1

#define USART2_PORT                     GPIOA
#define USART2_RCC                      RCC_APB1Periph_USART2
#define USART2_GPIO_RCC                 RCC_APB2Periph_GPIOA
#define USART2_CK_PIN                   GPIO_Pin_4
#define USART2_TX_PIN                   GPIO_Pin_2
#define USART2_RX_PIN                   GPIO_Pin_3
#define USART2_CTS_PIN                  GPIO_Pin_0
#define USART2_RTS_PIN                  GPIO_Pin_1
//#define REMAP_USART2

//======================================================

#define I2Cx_PORT                       GPIOB
#define I2Cx_GPIO_RCC                   RCC_APB2Periph_GPIOB

#define I2C1_RCC                        RCC_APB1Periph_I2C1
#define I2C1_SMBAI_PIN                  GPIO_Pin_5
#define I2C1_SCL_PIN                    GPIO_Pin_6
#define I2C1_SDA_PIN                    GPIO_Pin_7
#define I2C1_REMAP (0)	//0: Not remap / 1: Remap
#define I2C1R_SCL_PIN                   GPIO_Pin_8
#define I2C1R_SDA_PIN                   GPIO_Pin_9

#define I2C2_RCC                        RCC_APB1Periph_I2C2
#define I2C2_SMBAI_PIN                  GPIO_Pin_12
#define I2C2_SCL_PIN                    GPIO_Pin_10
#define I2C2_SDA_PIN                    GPIO_Pin_11
//=======================================================

#define SPI1_PORT                       GPIOA
#define SPI1_RCC                        RCC_APB2Periph_SPI1
#define SPI1_GPIO_RCC                   RCC_APB2Periph_GPIOA
#define SPI1_NSS_PIN                    GPIO_Pin_4
#define SPI1_SCK_PIN                    GPIO_Pin_5
#define SPI1_MISO_PIN                   GPIO_Pin_6
#define SPI1_MOSI_PIN                   GPIO_Pin_7
//#define REMAP_SPI1

#define  SPI2_PORT                       GPIOB
#define  SPI2_RCC                        RCC_APB1Periph_SPI2
#define  SPI2_GPIO_RCC                   RCC_APB2Periph_GPIOB
#define  SPI2_NSS_PIN                    GPIO_Pin_12
#define  SPI2_SCK_PIN                    GPIO_Pin_13
#define  SPI2_MISO_PIN                   GPIO_Pin_14
#define  SPI2_MOSI_PIN                   GPIO_Pin_15

//=======================================================
/*
#define RS485_USART					USART3
#define RS485_USART_RCC			RCC_APB1Periph_USART3
#define RS485_TR_IO_RCC			RCC_APB2Periph_GPIOB
#define RS485_TR_PORT				GPIOB
#define RS485_TX_PIN				GPIO_Pin_10
#define RS485_RX_PIN				GPIO_Pin_11

#define RS485_RD_IO_RCC			RCC_APB2Periph_GPIOE
#define RS485_RD_PORT				GPIOE
#define RS485_RD_PIN				GPIO_Pin_15

#define RS485_TX_Enable()		RS485_RD_PORT->BSRR |= RS485_RD_PIN
#define RS485_TX_Disable()	RS485_RD_PORT->BRR |= RS485_RD_PIN

#define RS485_PORTSOURCE		GPIO_PortSourceGPIOB
#define RS485_PINSOURCE			GPIO_PinSource11
#define RS485_EXTI_LINE			EXTI_Line11
#define RS485_EXTI_IRQn			EXTI3_IRQn

#define RS485_TIM						TIM9
#define RS485_TIM_RCC				RCC_APB2Periph_TIM9
#define RS485_TIM_IRQ				TIM1_BRK_TIM9_IRQn
*/
//=======================================================
////    Mobt@̒
#define U1_RX_BUFF_LEN     (128)
////    Mobt@̒
//			ۂɂ͂̑傫̃obt@2pӂ̂ŒӁD
#define U1_TX_BUFF_LEN     (512)
////		sR[hƂĈASCII
#define U1_NL_CODE					('\r')
////		GR[obNLFCRǉ邩
#define U1_DO_CRLF_ECHO			(1)

//=======================================================
////    Mobt@̒
#define U2_RX_BUFF_LEN     (128)
////    Mobt@̒
//			ۂɂ͂̑傫̃obt@2pӂ̂ŒӁD
#define U2_TX_BUFF_LEN     (512)
////		sR[hƂĈASCII
#define U2_NL_CODE					('\r')
////		GR[obNLFCRǉ邩
#define U2_DO_CRLF_ECHO			(1)
//=======================================================
////	Mobt@̒
#define RS485_TX_BUFF_LEN	(128)
////	Mobt@̒
#define RS485_RX_BUFF_LEN	(128)
////	M̉\ɂȂ܂ł̃fBC[usec]
#define RS485_RX_DELAY		(20)
//=======================================================

#endif /* __STBEEMINI_H */

