/**
 ******************************************************************************
 * @file	system_timer.h
 * @author	strv
 * @brief	CMSISSystemtimerg1ms^C}p
 ******************************************************************************
 */
#ifndef SYSTEMTIMER_H_
#define SYSTEMTIMER_H_

#include <stdint.h>
#include "platform_config.h"

//#define SYSTIMER_TICK_INTERVAL_HZ (1000)   //TimerCountUp֐Ă΂[HZ]
//#define SYSTIMER_USE_64BIT                 //TimervZ64bitgۂDŏZD64bitvZȂꍇ́CRgAEgD

#ifdef SYSTIMER_USE_64BIT
#define SYSTIMER_UINT_TYPE uint64_t
#else
#define SYSTIMER_UINT_TYPE uint32_t
#endif

void st_init(void);

//JE^̃JEgAbv֐D
//^C}[荞ݓŌĂ
void st_count_up(void);

//݂̎ԂԂ֐
//߂l : ݂̎[msec]
SYSTIMER_UINT_TYPE st_now(void);

//ʑ҂
// : ҂[msec]
void st_wait(SYSTIMER_UINT_TYPE);

//XgbvEHb`X^[g֐
void st_sw_start(void);

//XgbvEHb`X^[gĂ̎ԂԂ֐
//߂l : ݂̃bv^C[msec]
SYSTIMER_UINT_TYPE st_sw_lap(void);

//^C}IɃZbg֐
// : Zbgl[msec]
void st_set(SYSTIMER_UINT_TYPE);

#endif /* SYSTEMTIMER_H_ */
