/**
 ******************************************************************************
 * @file	led.c
 * @author	Seiga
 * @brief	I{[hLEDpCu
 * @see		LED_POLARITY_REVERSE
 ******************************************************************************
 */

#include "led.h"
#include "platform_config.h"

/**
 * @brief CjVCY֐
 * @param Ȃ
 * @return Ȃ
 *
 * K֐sOɖ{֐ŃCjVCY邱ƁB
 */
void led_init(void) {
	GPIO_InitTypeDef GPIO_InitStructure;

	RCC_APB2PeriphClockCmd(LED_RCC, ENABLE);

	GPIO_InitStructure.GPIO_Pin = LED1_PIN | LED2_PIN;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(LED_PORT, &GPIO_InitStructure);
}

/**
 * @brief LED_֐
 * @param led:	_LEDԍ(LED1,LED2)B
 * 	|Zqɂ镹L\B
 * @return Ȃ
 *
 * w肵ԍLED_B
 */
void led_on(LED led) {
	uint16_t port = 0;
	if (led & 0x01) {
		port |= LED1_PIN;
	}
	if (led & 0x02) {
		port |= LED2_PIN;
	}
#if defined(LED_POLARITY_REVERSE)
	GPIO_ResetBits(LED_PORT, port);
#else
	GPIO_SetBits(LED_PORT, port);
#endif
}

/**
 * @brief LED֐
 * @param led:	LEDԍ(LED1,LED2)B
 * 	|Zqɂ镹L\B
 * @return Ȃ
 *
 * w肵ԍLEDB
 */
void led_off(LED led) {
	uint16_t port = 0;
	if (led & 0x01) {
		port |= LED1_PIN;
	}
	if (led & 0x02) {
		port |= LED2_PIN;
	}
#if defined(LED_POLARITY_REVERSE)
	GPIO_SetBits(LED_PORT, port);
#else
	GPIO_ResetBits(LED_PORT, port);
#endif
}

/**
 * @brief LEDؑ֊֐
 * @param led:ؑւLEDԍ(LED1,LED2)
 * 	|Zqɂ镹L\
 * @return Ȃ
 *
 * w肵ԍLED̓_/ԂւB
 */
void led_toggle(LED led) {
	uint16_t port = led_get_state();
	led_set_state(~port & led);
}

/**
 * @brief LEDԎ擾֐
 * @param Ȃ
 * @return ݂LED
 *
 * ݂LEDԂ擾BerbgꂼLED_Ă1AĂ0B
 */
uint16_t led_get_state(void) {
	uint32_t port = 0;
#if defined(LED_POLARITY_REVERSE)
	if (!GPIO_ReadOutputDataBit(LED_PORT, LED1_PIN)) {
		port |= 0x01;
	}
	if (!GPIO_ReadOutputDataBit(LED_PORT, LED2_PIN)) {
		port |= 0x02;
	}
#else
	if (GPIO_ReadOutputDataBit(LED_PORT, LED1_PIN)) {
		port |= 0x01;
	}
	if (GPIO_ReadOutputDataBit(LED_PORT, LED2_PIN)) {
		port |= 0x02;
	}
#endif
	return port;
}

/**
 * @brief LEDԐݒ֐
 * @param state:	ݒ肷LED
 * @return Ȃ
 *
 * LEDԂݒ肷Berbgꂼ1œ_A0ŏB
 */
void led_set_state(uint16_t state) {
#if defined(LED_POLARITY_REVERSE)
	if (!(state & 0x01)) {
#else
	if (state & 0x01) {
#endif
		GPIO_SetBits(LED_PORT, LED1_PIN);
	} else {
		GPIO_ResetBits(LED_PORT, LED1_PIN);
	}

#if defined(LED_POLARITY_REVERSE)
	if (!(state & 0x02)) {
#else
	if (state & 0x02) {
#endif
		GPIO_SetBits(LED_PORT, LED2_PIN);
	} else {
		GPIO_ResetBits(LED_PORT, LED2_PIN);
	}
}
