/**
 * @file   Saver.cpp
 * @brief
 * @date   2009/05/05
 * @author ܂
*/
#include "Saver.h"

/**
 * @brief     ݒ
 * @param[in] sur 錳摜
 */
Saver::Saver(){
	
}
/**
 * @brief     I
 */
Saver::~Saver(){
	SDL_FreeSurface(sav);
}

SDL_Surface *Saver::Run(SDL_Surface *sur){
	Uint32 rmask, gmask, bmask, amask;
	SDL_PixelFormat *sur_fmt=sur->format;
	Uint8            sur_bpp=sur_fmt->BitsPerPixel;
	rmask = sur_fmt->Rmask;
	gmask = sur_fmt->Gmask;
	bmask = sur_fmt->Bmask;
	amask = sur_fmt->Amask;
	sav=SDL_CreateRGBSurface(sur->flags,sur->clip_rect.w,sur->clip_rect.h,sur_bpp,rmask,gmask,bmask,amask);
	img=sur;
	Check_Red();
	return sav;
}

void Saver::Check_Red(){
	SDL_PixelFormat *sur_fmt     =img->format;
	Uint16           sur_pitch   =img->pitch;
	Uint8           *sur_pixels_8=NULL;
	Uint8            sur_bypp    =sur_fmt->BytesPerPixel;
	Uint8            sur_bpp     =sur_fmt->BitsPerPixel;

	SDL_PixelFormat *tar_fmt     =sav->format;
	Uint16           tar_pitch   =sav->pitch;
	Uint8           *tar_pixels_8=NULL;
	Uint8            tar_bypp    =tar_fmt->BytesPerPixel;
	Uint8            tar_bpp     =tar_fmt->BitsPerPixel;
	Uint8            r_sam       =0x45;
	int       x,y;
	SDL_Color Color;
	//bN
	SDL_LockSurface(img);
	SDL_LockSurface(sav);
	sur_pixels_8=(Uint8*)img->pixels;
	tar_pixels_8=(Uint8*)sav->pixels;
	for(y=0;y<img->clip_rect.h;y++){
		for(x=0;x<img->clip_rect.w;x++){
			Uint8    *pix =&sur_pixels_8[sur_pitch*y+sur_bypp*x];
			Uint8    *tpix=&tar_pixels_8[tar_pitch*y+tar_bypp*x];
			switch(sur_bpp){
				case 8:
				{
					short  h=0,s=0,v=0;
					Uint32 pixel=*(Uint8*)pix;
					SDL_GetRGB(pixel,sur_fmt,&Color.r,&Color.g,&Color.b);
					ConvHSV(Color.r,Color.g,Color.b,&h,&s,&v);
					if(CheckH(h,0,10)&&s>0x3c&&v>0x3c);
					else                             Color.r=Color.g=Color.b=0x00;
					*tpix=SDL_MapRGB(tar_fmt,Color.r,Color.g,Color.b);
				}
				break;
				case 16:
				{
					short  h=0,s=0,v=0;
					Uint32 pixel=*(Uint16*)pix;
					SDL_GetRGB(pixel,sur_fmt,&Color.r,&Color.g,&Color.b);
					ConvHSV(Color.r,Color.g,Color.b,&h,&s,&v);
					if(CheckH(h,0,10)&&s>0x3c&&v>0x3c);
					else                             Color.r=Color.g=Color.b=0x00;
					*(Uint16 *)tpix=SDL_MapRGB(tar_fmt,Color.r,Color.g,Color.b);
				}
				break;
				case 24:
				{
					short  h=0,s=0,v=0;
					Uint32 pixel=*(Uint32*)pix;
					SDL_GetRGB(pixel,sur_fmt,&Color.r,&Color.g,&Color.b);
					ConvHSV(Color.r,Color.g,Color.b,&h,&s,&v);
					
					//if(CheckH(h,250,40)&&s>0x3c&&v>0x3c)printf("(%d,%d)[%d:%d:%d][%d:%d:%d]\n",x,y,Color.r,Color.g,Color.b,h,s,v);
					if(CheckH(h,0,10)&&s>0x3c&&v>0x3c);
					else                             Color.r=Color.g=Color.b=0x00;
					Uint32 color=SDL_MapRGB(tar_fmt,Color.r,Color.g,Color.b);
					if (SDL_BYTEORDER == SDL_BIG_ENDIAN) {
						tpix[0]=(color>>16)&0xff;
						tpix[1]=(color>>8) &0xff;
						tpix[2]= color     &0xff;
					} else {
						tpix[0]= color     &0xff;
						tpix[1]=(color>>8) &0xff;
						tpix[2]=(color>>16)&0xff;
					}

				}
				break;
				case 32:
				{
					short  h=0,s=0,v=0;
					Uint32 pixel=*(Uint32*)pix;
					SDL_GetRGB(pixel,sur_fmt,&Color.r,&Color.g,&Color.b);
					ConvHSV(Color.r,Color.g,Color.b,&h,&s,&v);
					if(CheckH(h,0,10)&&s>0x3c&&v>0x3c);
					else                             Color.r=Color.g=Color.b=0x00;
					*(Uint32 *)tpix=SDL_MapRGB(tar_fmt,Color.r,Color.g,Color.b);
				}
				break;
			}
		}
	}
	//
	SDL_UnlockSurface(sav);
	SDL_UnlockSurface(img);
}

/**
 * @brief     RGBJ[HSVJ[ɕϊ
 * @param[in] r Ԃ̃J[R[h(0x00->0xff)
 * @param[in] g ΂̃J[R[h(0x00->0xff)
 * @param[in] b ̃J[R[h(0x00->0xff)
 */
void Saver::ConvHSV(Uint8 r,Uint8 g,Uint8 b,short *h,short *v,short *s){
	*v=max(r,g,b);
	if(*v==0){
		//
		*h=0;
		*s=0;
		return;
	}
	*s=255*(max(r,g,b)-min(r,g,b))/max(r,g,b);
	if(*s==0){
		*h=0;
		return;
	}
	if(*v==r)     *h=60*(b-g)/(max(r,g,b)-min(r,g,b));
	else if(*v==g)*h=60*(r-b)/(max(r,g,b)-min(r,g,b))+120;
	else if(*v==b)*h=60*(g-r)/(max(r,g,b)-min(r,g,b))+240;
	*h%=360;
	if(*h<0)*h+=360;
	return;
}

/**
 * @brief     ől̎擾
 * @param[in] r Ԃ̃J[R[h(0x00->0xff)
 * @param[in] g ΂̃J[R[h(0x00->0xff)
 * @param[in] b ̃J[R[h(0x00->0xff)
 * @return    ől
 */
Uint8 Saver::max(Uint8 r,Uint8 g,Uint8 b){
	Uint8 ret=0;
	if(r>g){
		if(r>b){
			ret=r;
		}else{
			ret=b;
		}
	}else{
		if(g>b){
			ret=g;
		}else{
			ret=b;
		}
	}
	return ret;
}

/**
 * @brief     ŏl̎擾
 * @param[in] r Ԃ̃J[R[h(0x00->0xff)
 * @param[in] g ΂̃J[R[h(0x00->0xff)
 * @param[in] b ̃J[R[h(0x00->0xff)
 * @return    ŏl
 */
Uint8 Saver::min(Uint8 r,Uint8 g,Uint8 b){
	Uint8 ret=0;
	if(r<g){
		if(r<b){
			ret=r;
		}else{
			ret=b;
		}
	}else{
		if(g<b){
			ret=g;
		}else{
			ret=b;
		}
	}
	return ret;
}

bool Saver::CheckH(short h,short deg,Uint8 buf){
	if(deg-buf<0){
		return (((360+deg-buf)<h)||((h<(deg+buf))&&(h>=0)));
	}else{
		return ((h<deg+buf)&&(h>deg-buf));
	}
	return false;
}
