# -*- coding: utf-8 -*- #

#ccinoSubstaceAnd5
#
#Procuct by cciMo@Ultimate Gorl is Making an Everyday An annversary in curonet


from PySide2 import QtCore
from PySide2 import QtWidgets
import maya.cmds as cmds
import os
import os.path
import re


SLOT_NAMES = ['BaseColor  ','Metalness  ','Roughness','Normal       ','Height        ','Emissive     ']
EXTENSIONS = ['.png','.bmp','.exr','.gif','.hdr','.ico','.j2k','.jng','.jp2','.jpg','.jpeg','.jpeg-xr','.pbm','.pbmraw','.pfm','.pgm','.ppm','.ppmraw','.psd','.tga','.tif','.wbmp','.webp','.xpm']


class SubstanceImporter():
    def __init__(self):
                
        self.UI_init()
        
    def UI_init(self):
        #Create our main window
        self.winMain = QtWidgets.QDialog()

        self.winMain.setWindowTitle("ccinoSubstanceAnd5")
        self.winMain.setFixedSize(200,360)
        self.winMain.setWindowFlags(QtCore.Qt.WindowStaysOnTopHint)
        
        
        #Create vertical layout
        self.boxMain = QtWidgets.QVBoxLayout()
        self.winMain.setLayout(self.boxMain)
        
        #Create Dirctory Group box
        self.grpDirectory = QtWidgets.QGroupBox('Texture Directory')
        self.boxMain.addWidget(self.grpDirectory)
                                  
        
        #Create H layout in Dirctory Group box
        self.DirBoxH=[]
        self.DirBoxV = QtWidgets.QVBoxLayout()
        self.DirBoxH.append(QtWidgets.QHBoxLayout())
        self.grpDirectory.setLayout(self.DirBoxV)
        self.DirBoxV.addLayout(self.DirBoxH[0])
        
        #Create Push btn for browse Dirctory  in Group box
        self.btnDirectry = QtWidgets.QPushButton('Select Texture Directory')
        self.btnDirectry.setStyleSheet("background-color: #6495ed")
        self.DirBoxH[0].addWidget(self.btnDirectry)
        self.btnDirectry.clicked.connect(self.btnDirectryClicked)

        #Create checkbox for UDIM
        self.DirBoxH.append(QtWidgets.QHBoxLayout())
        self.DirBoxV.addLayout(self.DirBoxH[1])
        self.udimCheckBox = QtWidgets.QCheckBox('UDIM')
        self.DirBoxH[1].addWidget(self.udimCheckBox)
        self.udimCheckBox.stateChanged.connect(self.stateUdimCheckBox)


        #Create layout for texture extension

        
        #add combobox for file extenstions
        self.comboBoxTexEx = QtWidgets.QComboBox()
        self.DirBoxH[1].addWidget(self.comboBoxTexEx) 
        
        #Create List for texture extension which avaiable in substance
        self.comboBoxTexEx.addItems(EXTENSIONS)

        
        
        #Create Texture Slot Group box
        self.grpTexSlot = QtWidgets.QGroupBox('Texture Slots')
        self.boxMain.addWidget(self.grpTexSlot)
        
        
        #Create V layout for texture slots
        self.SlotBoxV = QtWidgets.QVBoxLayout()
        self.grpTexSlot.setLayout(self.SlotBoxV)
        
        self.SlotBoxH=[]
        self.chSlot=[]
        self.lineSlot=[]


        for slotname in SLOT_NAMES:
            tmpSlotBoxH= QtWidgets.QHBoxLayout()
            self.SlotBoxV.addLayout(tmpSlotBoxH)
            
            #Create CheckBoxs for BaseColor slot

            tmpchSlot = QtWidgets.QCheckBox(slotname)
            tmpSlotBoxH.addWidget(tmpchSlot)
            tmpchSlot.toggle()
                        
            #Create Line edit
            tmplineSlot = QtWidgets.QLineEdit()
            tmpSlotBoxH.addWidget(tmplineSlot)
            tmplineSlot.setText(slotname.strip())

            self.SlotBoxH.append(tmpSlotBoxH)
            self.chSlot.append(tmpchSlot)
            self.lineSlot.append(tmplineSlot)
        


    
        #Create Import Group box
        #self.grpConnect = QtWidgets.QGroupBox('Connect Texture')
        self.grpConnect = QtWidgets.QGroupBox()
        self.boxMain.addWidget(self.grpConnect)
        
        #Create H Layout
        self.ConnectBoxH = QtWidgets.QHBoxLayout()
        self.grpConnect.setLayout(self.ConnectBoxH)
       
       
        #Create Import Button
        self.btnConnectTex = QtWidgets.QPushButton('Connect Texture')
        self.btnConnectTex.setStyleSheet("background-color: #0000cd")

        self.ConnectBoxH.addWidget(self.btnConnectTex)
        self.btnConnectTex.setEnabled(0)
        self.btnConnectTex.clicked.connect(self.btnConnectTexClicked)

       
        
        self.winMain.show()        
            
    def btnDirectryClicked(self):
        self.ImportTexDir = QtWidgets.QFileDialog.getExistingDirectory()
        self.btnDirectry.setText(os.path.basename(self.ImportTexDir))
        if (self.ImportTexDir == None):
            print('No Texture Path selected.')           
        else:
            self.btnConnectTex.setEnabled(1)


     
    def stateUdimCheckBox(self):
        self.btnUdim.setEnabled(1)

    def btnUdimSignal(self):
        self.modelNameWithPath = QtWidgets.QFileDialog.getOpenFileName() 
        self.btnUdim.setText(os.path.basename(self.modelNameWithPath[0]))
        
    def btnConnectTexClicked(self):
        self.arnoldImport()

    """   
    def searchForString(self,search,string):
        myNewString = string.replace('_',' ')
        resultAsWord  = re.findall('\\b'+search +'\\b',myNewString)
        
        if (resultAsWord):
            return True
        
        else:
            return False
    """


    def getMtlFromObj(self,obj):
        mtl_list = []
        shapes = cmds.listRelatives(obj, shapes=True)
        if not shapes:
            return mtl_list
        SGs = cmds.listConnections(shapes[0], source=False, type='shadingEngine')
        if not SGs:
            return mtl_list
        mtl_list = cmds.ls(cmds.listConnections(SGs[0], destination=False), materials=True)
        return mtl_list

        
    
    def arnoldImport(self):
        fileExtention   = self.comboBoxTexEx.currentText()
        paramtersList   = []
        path            = self.ImportTexDir
        name            =cmds.ls(selection =True)

        sel=self.getMtlFromObj(name[0])
        if(len(sel)==0):
            return 0

        
        
        dicSlotsChkBoxs = {'baseColor':self.chSlot[0].isChecked(),'metalness':self.chSlot[1].isChecked()
                            ,'specularRoughness':self.chSlot[2].isChecked(),'Height':self.chSlot[3].isChecked(),
                            'normalCamera':self.chSlot[4].isChecked(),'emissionColor':self.chSlot[5].isChecked()}
        
        
        dictexNameUserInput = {'baseColor':self.lineSlot[0].text(),'metalness':self.lineSlot[1].text()
                            ,'specularRoughness':self.lineSlot[2].text(),'Height':self.lineSlot[3].text(),
                            'normalCamera':self.lineSlot[4].text(),'emissionColor':self.lineSlot[5].text()}
        
        for i in range(0,len(dicSlotsChkBoxs)):
            if (dicSlotsChkBoxs.values()[i] == True):
                paramtersList.append(dicSlotsChkBoxs.keys()[i])
                
     
        for i in range(0,len(sel)):    
            print sel[i]             
            shaderType      = cmds.nodeType(sel[i], i=True)
            shadingGroup    = cmds.listConnections(sel[i],type='shadingEngine')
            selLoop         = sel[i]
            
            
            if(shaderType[1] != 'aiStandardSurface'):   
                
                if(sel[i]=="lambert1"):
                    #cmds.disconnectAttr(sel[i] + '.outColor',shadingGroup[0] + '.surfaceShader')
                    sel[i]=name[0]+"_Mtl"
                    selLoop=sel[i]
                    materialNode = cmds.shadingNode('aiStandardSurface',asShader = True,name = sel[i])
                    SG = cmds.sets(renderable=1, noSurfaceShader=1, empty=1, name=(materialNode+'SG'))
                    cmds.sets(name[0], e=1, forceElement=SG)
                    cmds.connectAttr(materialNode + '.outColor',SG + '.surfaceShader')
                    shadingGroup[0]=SG
                else:
                    cmds.delete(sel[i])
                    #Creare new material
                    materialNode = cmds.shadingNode('aiStandardSurface',asShader = True,name = sel[i])
                    cmds.connectAttr(materialNode + '.outColor',shadingGroup[0] + '.surfaceShader')

            #scan all files in path
            for file in os.listdir(path):
                
                if (self.udimCheckBox.isChecked() == True):
                    modelName       = os.path.basename(self.modelNameWithPath[0])
                    modelName       = os.path.splitext(modelName)[0]
                    if (-1 == file.find('1001')):
                        print('UDIM not found in ' + file)
                        return 0
                else:
                    modelName       = shadingGroup[0]
                 
                #Search for udim
                #print(os.path.splitext(modelName)[0],file)
                #print modelName
                    
                   #search if the file ends with the correct extension or not
                if(file.endswith(fileExtention)):
                    #search for the material slots paramaters
                    for i in range(0,len(paramtersList)):
                        #if paramaters found in dic take user input
                        if(paramtersList[i] in dictexNameUserInput):
                            texName             = dictexNameUserInput.get(paramtersList[i])
                            #search for user names input in the texture it self
                            if(-1 < file.find(texName)):
                                texFullName = path +'/' + file
                                print(texFullName + ' is found')
                           
                                #Create t7exture node and make default connections
                                fileNode      = cmds.shadingNode('file',asTexture = True,isColorManaged =True,name = 'Tex_'+ selLoop +'_'+ paramtersList[i])
                                placeTex     = cmds.shadingNode('place2dTexture',asTexture = True)
                                

                                cmds.connectAttr(placeTex + '.outUV',fileNode + '.uvCoord')
                                cmds.connectAttr(placeTex + '.uvFilterSize',fileNode + '.uvFilterSize')
                                cmds.connectAttr(placeTex + '.coverage',fileNode + '.coverage')
                                cmds.connectAttr(placeTex + '.translateFrame',fileNode + '.translateFrame')
                                cmds.connectAttr(placeTex + '.rotateFrame',fileNode + '.rotateFrame')
                                cmds.connectAttr(placeTex + '.mirrorU',fileNode + '.mirrorU')
                                cmds.connectAttr(placeTex + '.mirrorV',fileNode + '.mirrorV')
                                cmds.connectAttr(placeTex + '.stagger',fileNode + '.stagger')
                                cmds.connectAttr(placeTex + '.wrapU',fileNode + '.wrapU')
                                cmds.connectAttr(placeTex + '.wrapV',fileNode + '.wrapV')
                                cmds.connectAttr(placeTex + '.repeatUV',fileNode + '.repeatUV')
                                cmds.connectAttr(placeTex + '.offset',fileNode + '.offset')
                                cmds.connectAttr(placeTex + '.rotateUV',fileNode + '.rotateUV')
                                cmds.connectAttr(placeTex + '.noiseUV',fileNode + '.noiseUV')
                                cmds.connectAttr(placeTex + '.vertexUvOne',fileNode + '.vertexUvOne')
                                cmds.connectAttr(placeTex + '.vertexUvTwo',fileNode + '.vertexUvTwo')
                                cmds.connectAttr(placeTex + '.vertexUvThree',fileNode + '.vertexUvThree')
                                cmds.connectAttr(placeTex + '.vertexCameraOne',fileNode + '.vertexCameraOne')
                                
                                #set texture node path 
                                cmds.setAttr(fileNode+'.fileTextureName',texFullName,type='string') 
                                if (self.udimCheckBox.isChecked() == True):
                                    cmds.setAttr(fileNode+'.uvTilingMode',3) 
                    
                                    
                                #if slot is roughness create gamma node then plug it to the shader itself    
                                if(paramtersList[i] == 'specularRoughness'):
                                    cmds.setAttr(fileNode + '.colorSpace' ,'Raw',type ='string')
                                    cmds.setAttr( fileNode + '.alphaIsLuminance', True)
                                    cmds.connectAttr(fileNode + '.outColor.outColorR',selLoop +'.'+paramtersList[i]) 
                                
                                #if the baseColor is the slot make the BaseColor weight 1 then connect
                                elif(paramtersList[i] == 'baseColor'):
                                    cmds.setAttr(selLoop+'.base' ,1)
                                    #connect the texture node with the gamma node one
                                    cmds.connectAttr(fileNode + '.outColor',selLoop + '.' +paramtersList[i] ) 
                                
                                #if the specular is the slot make the specular weight 1 then connect    
                                elif(paramtersList[i] == 'metalness'):
                                    cmds.setAttr(selLoop+'.metalness' ,1)
                                    #connect the texture node with the gamma node one
                                    cmds.connectAttr(fileNode + '.outAlpha',selLoop + '.' +paramtersList[i] )
                                    cmds.setAttr( fileNode + '.alphaIsLuminance', True)
                                    cmds.setAttr(fileNode + '.colorSpace' ,'Raw',type ='string') 
                                
                                #if the emssion is the slot make the emssion weight 1 then connect    
                                elif(paramtersList[i] == 'emissionColor'):
                                    cmds.setAttr(selLoop+'.emission' ,1)
                                    #connect the texture node with the gamma node one
                                    cmds.connectAttr(fileNode + '.outColor',selLoop + '.' +paramtersList[i] ) 
                                    
                                #if the bump is the slot create bump node then make it to normal then connect
                                elif(paramtersList[i] == 'normalCamera'):
                                    cmds.setAttr(fileNode + '.colorSpace' ,'Raw',type ='string')
                                    #cmds.setAttr(fileNode + '.colorSpace' ,'Raw',type ='string')
                                    bmpNode = cmds.shadingNode( 'bump2d', asUtility=True)
                                    cmds.setAttr(bmpNode + '.bumpInterp',1)
                                    cmds.connectAttr(fileNode + '.outAlpha',bmpNode + '.bumpValue') 
                                    cmds.connectAttr(bmpNode + '.outNormal',selLoop +'.'+paramtersList[i])

                                #if the Height is the slot create Height map
                                elif(paramtersList[i] == 'Height'):
                                    cmds.setAttr(fileNode + '.colorSpace' ,'Raw',type ='string')
                                    cmds.setAttr( fileNode + '.alphaIsLuminance', True)
                                    dispNode = cmds.shadingNode( 'displacementShader', asUtility=True)
                                    cmds.connectAttr(fileNode + '.outAlpha',dispNode + '.displacement') 
                                    cmds.connectAttr(dispNode + '.displacement',shadingGroup[0] +'.displacementShader')													
                                    
                                #if it's anyslot except above connect it directly  
                                else:
                                    cmds.connectAttr(fileNode + '.outColor',selLoop +'.'+paramtersList[i]) 
                
                else:
                    print('Can\'t find '+shadingGroup[0]+' in ' + file)

                    
def main():
    plugin = SubstanceImporter()




