/***********************************************************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products.
* No other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
* applicable laws, including copyright laws. 
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED
* OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY
* LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE FOR ANY DIRECT,
* INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR
* ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability 
* of this software. By using this software, you agree to the additional terms and conditions found by accessing the 
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2012, 2019 Renesas Electronics Corporation. All rights reserved.
***********************************************************************************************************************/

/***********************************************************************************************************************
* File Name    : r_cg_iica_user.c
* Version      : Code Generator for RL78/G10 V1.05.03.02 [20 Nov 2019]
* Device(s)    : R5F10Y47
* Tool-Chain   : CCRL
* Description  : This file implements device driver for IICA module.
* Creation Date: 2022/04/25
***********************************************************************************************************************/

/***********************************************************************************************************************
Includes
***********************************************************************************************************************/
#include "r_cg_macrodriver.h"
#include "r_cg_iica.h"
/* Start user code for include. Do not edit comment generated here */
#include <string.h>		//֘AŕKv
/* End user code. Do not edit comment generated here */
#include "r_cg_userdefine.h"

/***********************************************************************************************************************
Pragma directive
***********************************************************************************************************************/
#pragma interrupt r_iica0_interrupt(vect=INTIICA0)
/* Start user code for pragma. Do not edit comment generated here */
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
Global variables and functions
***********************************************************************************************************************/
extern volatile uint8_t   g_iica0_master_status_flag;  /* iica0 master flag */ 
extern volatile uint8_t   g_iica0_slave_status_flag;   /* iica0 slave flag */
extern volatile uint8_t * gp_iica0_rx_address;         /* iica0 receive buffer address */
extern volatile uint16_t  g_iica0_rx_cnt;              /* iica0 receive data length */
extern volatile uint16_t  g_iica0_rx_len;              /* iica0 receive data count */
extern volatile uint8_t * gp_iica0_tx_address;         /* iica0 send buffer address */
extern volatile uint16_t  g_iica0_tx_cnt;              /* iica0 send data count */
/* Start user code for global. Do not edit comment generated here */
int _i2c_err_cnt=0;
unsigned char _i2c_err_list[10];	//fobOpɃG[i[
i2c_data* _i2c_recv_data;			//Mobt@\̂̃AhX
i2c_data* _i2c_send_data;			//Mobt@\̂̃AhX
uint16_t _i2c_recv_num=0;			//MJEg
uint16_t _i2c_send_num=0;			//MJEg
uint8_t _i2c_recv_buf_temp[I2C_MAX_BUF];	//Mf[^ꎞi[obt@@MɎMobt@ֈڂ
uint8_t _i2c_send_buf_temp[I2C_MAX_BUF];	//Mf[^ꎞi[obt@@MɑMobt@ڂ
uint8_t _i2c_address=0;				//obt@\̂̐ؑ֗pAhX
uint8_t _i2c_address_recv_f=0;		//AhXM
// r_iica0_callback_slave_sendend  WREL0 = 1U QRgAEg
// 9bitڂɂ邽WTIM0 = 0U RgAEg
// if (1U == SPD0) őM@\̏s
/* End user code. Do not edit comment generated here */

/***********************************************************************************************************************
* Function Name: r_iica0_interrupt
* Description  : None
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
static void __near r_iica0_interrupt(void)
{
    if ((IICS0 & _80_IICA_STATUS_MASTER) == 0U)
    {
        iica0_slavehandler();
    }
}
/***********************************************************************************************************************
* Function Name: iica0_slavehandler
* Description  : This function is IICA0 slave handler.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
static void iica0_slavehandler(void)
{
    /* Control for stop condition */
    if (1U == SPD0)
    {    
        /* Get stop condition */
        SPIE0 = 0U;
        g_iica0_slave_status_flag = 1U;
		i2c_reset_send_buf(_i2c_address);		//M@\Đݒ
		i2c_reset_recv_buf(_i2c_address);		//M@\Đݒ
    }
    else
    {
        if ((g_iica0_slave_status_flag & _80_IICA_ADDRESS_COMPLETE) == 0U)
        {
            if (1U == COI0)
            {
                SPIE0 = 1U;
                g_iica0_slave_status_flag |= _80_IICA_ADDRESS_COMPLETE;
                
                if (1U == TRC0)
                {
                    WTIM0 = 1U;
  
                    if (g_iica0_tx_cnt > 0U)
                    {
                        IICA0 = *gp_iica0_tx_address;
                        gp_iica0_tx_address++;
                        g_iica0_tx_cnt--;
                    }
                    else
                    {
                        r_iica0_callback_slave_sendend();
                        //WREL0 = 1U;	//M܂̂ŃRgAEg
                    }
                }
                else
                {
                    ACKE0 = 1U;
                    //WTIM0 = 0U;	//9bitڊɂ邽߃RgAEg
                    WREL0 = 1U;
                }
            }
            else
            {
                r_iica0_callback_slave_error(MD_ERROR);
            }
        }
        else
        {
            if (1U == TRC0)
            {
                if ((0U == ACKD0) && (g_iica0_tx_cnt != 0U))
                {
                    r_iica0_callback_slave_error(MD_NACK);
                }
                else
                {
                    if (g_iica0_tx_cnt > 0U)
                    {
                        IICA0 = *gp_iica0_tx_address;
                        gp_iica0_tx_address++;
                        g_iica0_tx_cnt--;
                    }
                    else
                    {
                        r_iica0_callback_slave_sendend();
                        //WREL0 = 1U;	//M܂̂ŃRgAEg
                    }
                }
            }
            else
            {
                if (g_iica0_rx_cnt < g_iica0_rx_len)
                {
                    *gp_iica0_rx_address = IICA0;
                    gp_iica0_rx_address++;
                    g_iica0_rx_cnt++;

                    if (g_iica0_rx_cnt == g_iica0_rx_len)
                    {
                        WTIM0 = 1U;
                        WREL0 = 1U;
                        r_iica0_callback_slave_receiveend();
                    }
                    else
                    {
                        WREL0 = 1U;
                    }
                }
                else
                {
                    WREL0 = 1U;
                }
            }
        }
    }
}
/***********************************************************************************************************************
* Function Name: r_iica0_callback_slave_error
* Description  : This function is a callback function when IICA0 slave error occurs.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
static void r_iica0_callback_slave_error(MD_STATUS flag)
{
    /* Start user code. Do not edit comment generated here */
	_i2c_err_list[_i2c_err_cnt%10]=flag;	//G[i[10Oobt@ƂĎg
	_i2c_err_cnt++;
	LREL0 = 1U;		//̂܂܏I
    /* End user code. Do not edit comment generated here */
}
/***********************************************************************************************************************
* Function Name: r_iica0_callback_slave_receiveend
* Description  : This function is a callback function when IICA0 finishes slave reception.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
static void r_iica0_callback_slave_receiveend(void)
{
    /* Start user code. Do not edit comment generated here */
	i2c_inc_recv_buf();		//̃f[^M鏀
    /* End user code. Do not edit comment generated here */
}
/***********************************************************************************************************************
* Function Name: r_iica0_callback_slave_sendend
* Description  : This function is a callback function when IICA0 finishes slave transmission.
* Arguments    : None
* Return Value : None
***********************************************************************************************************************/
static void r_iica0_callback_slave_sendend(void)
{
    /* Start user code. Do not edit comment generated here */
	i2c_inc_send_buf();		//̃f[^𑗐M鏀
    /* End user code. Do not edit comment generated here */
}

/* Start user code for adding. Do not edit comment generated here */

//Mobt@ݒ肷
void i2c_set_recv_buf(i2c_data* p_data){
	_i2c_recv_data=p_data;						//Mf[^i[ݒ
	memset(_i2c_recv_buf_temp,0,I2C_MAX_BUF);	//ꎞMobt@NA
	_i2c_recv_num=0;							//MZbg
	i2c_reset_recv_buf(_i2c_address);			//M@\
}
//Mobt@ݒ肷
void i2c_set_send_buf(i2c_data* p_data){
	_i2c_send_data=p_data;					//Mf[^i[ݒ
	i2c_reset_send_buf(_i2c_address);		//M@\
}
//obt@փf[^i[
void i2c_set_data(i2c_data* p_data,uint8_t* data,int data_len){
	data_len=(data_len>I2C_MAX_BUF)?I2C_MAX_BUF:data_len;	//
	memcpy(p_data->data,data,data_len);		//Rs[
	p_data->update_f=1;						//XVtO𗧂Ă
}
//obt@f[^擾
void i2c_get_data(i2c_data* p_data,uint8_t* data,int data_len){
	data_len=(data_len>I2C_MAX_BUF)?I2C_MAX_BUF:data_len;	//
	memcpy(data,p_data->data,data_len);		//Rs[
	p_data->update_f=0;						//XVtO
}
//M@\
void i2c_reset_recv_buf(int address){
	//obt@𕪂ĎMɃf[^ς鎖h
	if(_i2c_recv_num>0){							//AhX1ByteȏM
		i2c_set_data(&_i2c_recv_data[address],_i2c_recv_buf_temp,_i2c_recv_num);//Mf[^ڂւ
	}
	memset(_i2c_recv_buf_temp,0,I2C_MAX_BUF);		//ꎞMobt@NA
	_i2c_recv_num=0;								//MJEgZbg
	_i2c_address_recv_f=0;							//AhXMtOZbg
	R_IICA0_Slave_Receive(_i2c_recv_buf_temp,1);	//Mobt@(M1Œ)
}
//M@\
void i2c_reset_send_buf(int address){
	//obt@𕪂ĂPf[^M
	//if(_i2c_send_data[address].update_f){
		i2c_get_data(&_i2c_send_data[address],_i2c_send_buf_temp,I2C_MAX_BUF);//Mf[^ڂւ
	//}
	_i2c_send_num=0;								//MJEgZbg
	R_IICA0_Slave_Send(_i2c_send_buf_temp,1);		//Mobt@(M1Œ)
}

//f[^𒀎M
void i2c_inc_recv_buf(void){
	if(_i2c_address_recv_f==0){				//1ByteڂM̏
		_i2c_address=_i2c_recv_buf_temp[0];	//AhXؑ
		i2c_get_data(&_i2c_send_data[_i2c_address],_i2c_send_buf_temp,I2C_MAX_BUF);//Mf[^ڂւ
		_i2c_address_recv_f=1;
		gp_iica0_rx_address=_i2c_recv_buf_temp;	//擪MȂ
	}else{
		_i2c_recv_num++;					//f[^MJEgAbv
	}

	if(_i2c_recv_num>=I2C_MAX_BUF){			//Mobt@g؂
		LREL0 = 1U;							//oXJ
		i2c_reset_recv_buf(_i2c_address);	//M@\Đݒ
	}else{
		g_iica0_rx_cnt=0;					//ĎMɌēMNA
	}
}
//f[^𒀎M
void i2c_inc_send_buf(void){
	_i2c_send_num++;
	if(_i2c_send_num>=I2C_MAX_BUF||ACKD0==0){	//Mobt@g؂ or I̍}
		LREL0 = 1U;								//oXJ
		i2c_reset_send_buf(_i2c_address);		//M@\Đݒ
		i2c_reset_recv_buf(_i2c_address);		//M@\Đݒ
	}else{
		IICA0 = *gp_iica0_tx_address;			//̑Mf[^ݒ
		gp_iica0_tx_address++;					//Mf[^̊i[XV
		g_iica0_tx_cnt=0;						//đMɌēMNA
	}
}

//Mς݃f[^擾
int get_i2c_recv_cnt(void){
	return _i2c_recv_num;
}
//Mς݃f[^擾
int get_i2c_send_cnt(void){
	return _i2c_send_num;
}

//oX̏Ԃ擾
int i2c_busy(void){
	return IICBSY0;
}
//f[^MĂ邩mF
int i2c_recved(int address){
	int value=_i2c_recv_data[address].update_f;
	_i2c_recv_data[address].update_f=0;
	return value;
}
//IɎsďԊmF(gp)
int i2c_check(void){
	//oXt[̂ƂMobt@Đݒ肷
	if(i2c_busy()==0){
		if(get_i2c_recv_cnt()>0){
			i2c_reset_recv_buf(_i2c_address);
		}
		if(get_i2c_send_cnt()>0){
			i2c_reset_send_buf(_i2c_address);
		}
	}
	return 1;
}
/* End user code. Do not edit comment generated here */
