###########################################
# Ubuntu boot script V7 for Android       #
# Built by Zachary Powell (zacthespack)   #
# and Martin Møller (Tuxling)             #
# Thanks to:                              #
# Johan (sciurius)                        #
# Marshall Levin                          #
# and to everyone at XDA!                 #
###########################################

###########################################
# This is a function we use to stop the   #
# script in case of errors                #
###########################################
error_exit() {
    echo "Error: $1"
    exit 1
}

###########################################
# Check for root                          #
###########################################
perm=$(id|cut -b 5)
if [ "$perm" != "0" ];then error_exit "This script requires root! Type: su"; fi
#mount -o remount,rw /dev/block/mmcblk0p5 /system

###########################################
# Set up variables                        #
###########################################
export imgfile=$(dirname $0)/ubuntu.img    # Default image file, another can be set by using an argument
export bin=/system/bin
export mnt=/data/local/mnt
export USER=root
if [[ ! -d $mnt ]]; then mkdir $mnt; fi
export PATH=$bin:/usr/bin:/usr/local/bin:/usr/sbin:/bin:/usr/local/sbin:/usr/games:$PATH
export TERM=linux
export HOME=/root

###########################################
# Handle arguments if present             #
###########################################
if [ $# -ne 0 ]; then
    if [ -f $1 ]; then # Is full path present?
        imgfile=$1

	elif [ -f $(dirname $0)/$1 ]; then # Is only a filename present?
        imgfile=$(dirname $0)/$1

	else
        error_exit "Image file not found!($1)"
    fi
fi

###########################################
# If a md5 file is found we check it here #
###########################################
if [ -f $imgfile.md5 ]; then
    echo -n "Validating image checksum... "
    busybox md5sum -c -s $imgfile.md5
    if [ $? -ne 0 ];then
        echo "FAILED!"
        error_exit "Checksum failed! The image is corrupted!"
    else
        echo "OK"
        rm ./$imgfile.md5
    fi
fi

###########################################
# Set up loop device and mount image      #
###########################################
echo -n "Checking loop device... "
if [ -b /dev/block/loop255 ]; then
	echo "FOUND"
else
	echo "MISSING"
	# Loop device not found so we create it and verify it was actually created
	echo -n "Creating loop device... "
	busybox mknod /dev/block/loop255 b 7 255
	if [ -b /dev/block/loop255 ]; then
		echo "OK"
	else
		echo "FAILED"
		error_exit "Unable to create loop device!"
	fi
fi

busybox losetup /dev/block/loop255 $imgfile
if [ $? -ne 0 ];then error_exit "Unable to attach image to loop device! (Image = $imgfile)"; fi

busybox mount -t ext2 /dev/block/loop255 $mnt
if [ $? -ne 0 ];then error_exit "Unable to mount the loop device!"; fi

# Verify the image was actually mounted by checking if $mnt/root folder is found
#if [ -d $mnt/root ]; then
#	echo "Image mounted"
#else
#	echo "Unable to mount image!"
#	exit 1
#fi

###########################################
# Mount all required partitions           #
###########################################
busybox mount -t devpts devpts $mnt/dev/pts
if [ $? -ne 0 ];then error_exit "Unable to mount $mnt/dev/pts!"; fi
busybox mount -t proc proc $mnt/proc
if [ $? -ne 0 ];then error_exit "Unable to mount $mnt/proc!"; fi
busybox mount -t sysfs sysfs $mnt/sys
if [ $? -ne 0 ];then error_exit "Unable to mount $mnt/sys!"; fi
busybox mount -o bind /sdcard $mnt/sdcard
if [ $? -ne 0 ];then error_exit "Unable to bind $mnt/sdcard!"; fi

###########################################
# Checks if you have a external sdcard    #
# and mounts it if you do                 #
###########################################
if [ -d /sdcard/external_sd ]; then
	busybox mount -o bind /sdcard/external_sd  $mnt/external_sd
fi
if [ -d /Removable/MicroSD ]; then
	busybox mount -o bind /Removable/MicroSD  $mnt/external_sd
fi
# This is for the HD version of the Archos 70 internet tablet, may be the same for the SD card edition but i dont know.
if [ -d /storage ]; then
	busybox mount -o bind /storage  $mnt/external_sd
fi

###########################################
# Sets up network forwarding              #
###########################################
busybox sysctl -w net.ipv4.ip_forward=1
if [ $? -ne 0 ];then error_exit "Unable to forward network!"; fi
echo "nameserver 8.8.8.8" > $mnt/etc/resolv.conf
if [ $? -ne 0 ];then error_exit "Unable to write resolv.conf file!"; fi
echo "nameserver 8.8.4.4" >> $mnt/etc/resolv.conf
echo "127.0.0.1 localhost" > $mnt/etc/hosts
if [ $? -ne 0 ];then error_exit "Unable to write hosts file!"; fi
echo "Ubuntu is configured with SSH and VNC servers that can be accessed from the IP:"
ifconfig eth0
echo " "

###########################################
# Chroot into ubuntu                      #
###########################################
busybox chroot $mnt /root/init.sh
if [ $? -ne 0 ];then error_exit "Unable to chroot into linux!"; fi

###########################################
# Shut down ubuntu                        #
###########################################
echo "Shutting down Ubuntu ARM"
for pid in `lsof | grep $mnt | sed -e's/  / /g' | cut -d' ' -f2`; do kill -9 $pid >/dev/null 2>&1; done
sleep 5
umount $mnt/sdcard
umount $mnt/external_sd
umount $mnt/dev/pts
umount $mnt/proc
umount $mnt/sys
umount $mnt
losetup -d /dev/block/loop255
