		.h8300h
		
		.include "wait.inc"
		
		.equ	I2C_BIT_SCL,	3
		.equ	I2C_BIT_SDA,	2
		.equ	I2C_DDR_SHADOW,	_P3DDR_SHADOW
		

		.section .text

i2c_sda_write:
		push.w	r0
		mov		@I2C_DDR_SHADOW, r0l
		bset	#I2C_BIT_SDA, r0l
		bra		0f
i2c_sda_read:
		push.w	r0
		mov		@I2C_DDR_SHADOW, r0l
		bclr	#I2C_BIT_SDA, r0l
0:
		bset	#I2C_BIT_SCL, r0l			; NbN͏ɏo
		mov.b	r0l, @I2C_DDR_SHADOW		; SHADOWɒlۑ
		mov.b	r0l, @_I2C_DDR
		pop.w	r0
		rts

		;
		; I2CoX̏ݒ
		;	|[gݒ
		;	SCL=1 SDA=1
		;
		; WX^t
		;	r1l	o̓|[gf[^
		.global _i2c_init
_i2c_init:
		push.l	er0
		jsr		i2c_sda_write
		mov.b	@_I2C_DR, r0l
		bset	#I2C_BIT_SDA, r0l
		bset	#I2C_BIT_SCL, r0l
		mov.b	r0l, @_I2C_DR
		pop.l	er0
		rts

		; I2CoX̃X^[g𐶐
		;
		; WX^t
		;	r1l	o̓|[gf[^
		.global	_i2c_start
_i2c_start:
		push.l	er1
		
		jsr		i2c_sda_write
		
		mov.b	@_I2C_DR, r1l
		
		; X^[g
		bset	#I2C_BIT_SCL, r1l
		bset	#I2C_BIT_SDA, r1l
		mov.b	r1l, @_I2C_DR
		_NOP_nSEC 600
		
		bclr	#I2C_BIT_SDA, r1l
		mov.b	r1l, @_I2C_DR
		_NOP_nSEC 600
		
		bclr	#I2C_BIT_SCL, r1l
		mov.b	r1l, @_I2C_DR
		
		pop.l	er1
		rts

		; I2CoXɃXgbvo͂
		;
		; WX^t
		;	r1l	o̓|[gf[^
		.global	_i2c_stop
_i2c_stop:
		push	er1
		jsr		@i2c_sda_write
		
		mov		@_I2C_DR, r1l
		bset	#I2C_BIT_SCL, r1l
		mov		r1l, @_I2C_DR
		
		_NOP_nSEC 600
		
		bset	#I2C_BIT_SDA, r1l
		mov		r1l, @_I2C_DR
		pop		er1
		rts

		
		;
		; I2CoXɏACK𓾂
		;
		; internal
		;	r0l	o̓f[^(VtgWX^)
		;	r0h	free
		;	r1l	o̓|[gf[^
		;	r1h	free
		;	r2l	rbgJEg
		.global	_i2c_write
_i2c_write:
		push.l	er1
		push.l	er2

		jsr		i2c_sda_write
		
		mov.b	@_I2C_DR, r1l
		mov.b	#8, r2l
0:
		
		; SDA => C(0/1)
		shal.b	r0l
		bst		#I2C_BIT_SDA, r1l
		mov.b	r1l, @_I2C_DR
		_NOP_nSEC 1300			; tLOW
		
		; SCL 0 => 1
		bset	#I2C_BIT_SCL, r1l
		mov.b	r1l, @_I2C_DR
		_NOP_nSEC 600			; tHIGH

		; SCL 1 => 0
		bclr	#I2C_BIT_SCL, r1l
		mov.b	r1l, @_I2C_DR

		dec.b	r2l
		bne		0b
		
		jsr	i2c_sda_read
		
		_NOP_nSEC 1300			; tLOW
		
		bset	#I2C_BIT_SCL, r1l
		mov.b	r1l, @_I2C_DR	; SCL 0=>1
		
		mov.b	@_I2C_DR, r2l

		_NOP_nSEC 600			; tHIGH
		
		bclr	#I2C_BIT_SCL, r1l
		mov.b	r1l, @_I2C_DR	; SCL 1=>0

		mov		#0, er0
		bld		#I2C_BIT_SDA, r2l		; SDA => C
		bst		#0, r0l
		;mov.b	r2l, r0l
		
		
		pop.l	er2
		pop.l	er1
		
		rts

		; internal
		;	er0	RETVAL: ̓f[^(VtgWX^)
		;	r1l	|[gf[^
		;	r1h	|[gf[^([hp)
		;	r2l	rbgJEg
		.global	_i2c_read
_i2c_read:
		push.l	er1
		push.l	er2

		jsr		i2c_sda_read		

		mov		@_I2C_DR, r1l
				
		sub		er0, er0
		mov		#8, r2l
0:
		bset	#I2C_BIT_SCL, r1l
		mov		r1l, @_I2C_DR
		_NOP_nSEC 1300
		
		; SCLK=1̂Ƃf[^ωȂ
		mov		@_I2C_DR, r0h
		bld		#I2C_BIT_SDA, r0h	; SDA -> C
		rotxl	r0l					; r0lC݂Ń[e[g
		
		bclr	#I2C_BIT_SCL, r1l
		mov		r1l, @_I2C_DR
		_NOP_nSEC 1300
		
		dec		r2l
		bne		0b

		pop.l	er2
		pop.l	er1
		rts

		; I2CoXACK𑗏o
		;
		; input
		;		ER0 bit0 0=ACK 1=NCK
		; internal
		;	r1l	o̓|[gf[^
		.global	_i2c_ack
_i2c_ack:
		push.l	er1
		
		jsr		@i2c_sda_write
		
		mov		@_I2C_DR, r1l
		
		; ACK/NCKԃZbg
		bld		#1, r0l
		bst		#I2C_BIT_SDA, r1l
		mov		r1h, @_I2C_DR
											; tSU;DAT 100ns		
		bset	#I2C_BIT_SCL, r1l
		mov		r1l, @_I2C_DR				; SCL 0=>1
		_NOP_nSEC 600						; tHIGH 0.6S
		bclr	#I2C_BIT_SCL, r1l
		mov		r1l, @_I2C_DR				; SCL 1=>0
		sub		er0, er0

		pop.l	er1
		rts		

