		.h8300h
		.file "io_lcd.s"

		.section .text

		.include "io_lcd.inc"
		.include "wait.inc"

		.equ	LCD_BUSY_HANDSHAKE, 1
		.equ	LCD_RW_PULLDOWN, 1

		.equ	LCD_BIT_RW,			6
		.equ	LCD_BIT_E,			5
		.equ	LCD_BIT_RS,			4
		.equ	LCD_DR_MASK,		0b01111111
		.equ	LCD_DR_DATA_MASK,	0b00001111

		.macro	debugout text
		push.l	er0
		mov.l	#\text, er0
		jsr		@_sci_puts
		pop.l	er0
		.endm

msg1:	.string	"msg1\r\n\0"
msg2:	.string	"msg2\r\n\0"
msg3:	.string	"msg3\r\n\0"
msg4:	.string	"msg4\r\n\0"
msg5:	.string	"msg5\r\n\0"
msg6:	.string	"msg6\r\n\0"
msg7:	.string	"msg7\r\n\0"
msg8:	.string	"msg8\r\n\0"

		.global _io_lcd_init
_io_lcd_init:
		push.l	er0

		mov.b	#0xff, r0l
		mov.b	r0l, @_LCD_DDR
		mov.b	#0x00, r0l
		mov.b	r0l, @_LCD_DR

		;debugout	msg1
			
		_WAIT_uSEC 150000
		
		mov.b	#0b00000000, r0l	; RS=OFF RW=OFF
		jsr		_lcd_rs

		;debugout	msg2
		
		mov.b	#0b0011, r0l
		jsr		out_nibble
		
		;_WAIT_uSEC	41000
		_WAIT_uSEC	4100
		;_WAIT_uSEC	3800
		;debugout	msg3
		
		
		mov		#0b0011, r0l
		jsr		out_nibble
		
		;debugout	msg4
		
		_WAIT_uSEC	100
		;_WAIT_uSEC	1000
		
		mov		#0b0011, r0l
		jsr		out_nibble
		
		;debugout	msg5
		
		jsr		_busy_test
		
		mov.b	#0b00000000, r0l
		jsr	_lcd_rs
		
		;debugout	msg6
		
		mov		#0b0010, r0l
		jsr		out_nibble
		
		; t@NVZbg
		mov.b	#0b00101000, r0l
		_IO_LCD_OUT4
		
		_IO_LCD_CLEAR
		_IO_LCD_HOME

		mov.b	#IO_LCD_DISPLAY_ON, r0l
		_IO_LCD_DISPLAY
		
		; Gg[[h
		mov.b	#0b00000110, r0l
		_IO_LCD_OUT4
		
		pop.l	er0
		rts

		; -------------------------------------------------
		; LCD ~BUSY҂
		;	LCD_BUSY_HANDSHAKE  defined łȂꍇA1.5ms
		;   EFCgőւ
		; 
		;	Ȃ
		; o
		;	Ȃ
		; -------------------------------------------------
		.global busybuf;
busybuf:	.skip 256, 0xff
ebusybuf:
		.global _busy_test
_busy_test:
		.ifdef LCD_BUSY_HANDSHAKE
		push	er0
		push	er1
		push	er2
		
		mov		#busybuf, er2
		
		mov.b	#(~LCD_DR_DATA_MASK), r0l
		mov.b	r0l, @_LCD_DDR
		
		mov.b	@_LCD_DR, r0l			; [vʂ r0l  LCD ݃f[^Ci[
		and.b	#(~LCD_DR_MASK), r0l	; LCDƊ֌WȂrbgی, LCD֘A0NA
		bset	#LCD_BIT_RW, r0l		; {Tu[`͏Read
_busy_test_1:
		mov.b	r0l, @_LCD_DR
		
		.if 0
		cmp		#ebusybuf, er2
		bne		1f
		jmp		0x100
1:		mov		r0l, @er2
		inc		#1, er2
		.endif
		
		; 140ns (bset߂Ŋm)

		bset	#LCD_BIT_E, r0l
		mov.b	r0l, @_LCD_DR
		
		_NOP_nSEC 320
		
		mov.b	@_LCD_DR, r1h
		
		bclr	#LCD_BIT_E, r0l
		mov.b	r0l, @_LCD_DR
		
		;;_NOP_nSEC 680@(E TCN 1000ns ̖͑߂Ŋm
		
		bset	#LCD_BIT_E, r0l
		mov.b	r0l, @_LCD_DR
		
		_NOP_nSEC 320
		
		mov.b	@_LCD_DR, r1l

		bclr	#LCD_BIT_E, r0l		
		mov.b	r0l, @_LCD_DR
		
		;; _NOP_nSEC 680				; [vI=3,N=2mۂ邽߃EFCgsv
		
		btst	#3, r1h				; I=1
		bne		_busy_test_1		; I=2, N=2
		
		pop		er2
		pop		er1
		pop		er0
		.else
		_WAIT_uSEC	1500		; F킹œ삷ŏlݒ(1.5ms)
		.endif
		rts

		; -------------------------------------------------
		; LCDXe[^Xǂ݂Ƃ
		; 
		;	R0L = RS/RW rbg@(RW LCD_BUSY_HANDSHAKE tAZûݗL
		;         76543210	
		;         -#-#----
		; o
		;	Ȃ
		; -------------------------------------------------
		.global _lcd_rs
_lcd_rs:
		push	er0
		
		.ifdef LCD_BUSY_HANDSHAKE
		; RWɂ킹b0`b3̓o͂ύX
		btst	#LCD_BIT_RW, r0l
		beq		_lcd_w
		mov.b	#0xf0, r0h		; RW=1(READ) b0-b3͂
		bra		_lcd_rw0
_lcd_w:
		mov.b	#0xff, r0h		; RW=0(WRITE) b0-b3o͂
_lcd_rw0:
		mov.b	r0h, @_LCD_DDR

		mov.b	@_LCD_DR, r0h
		and		#0b01010000, r0l
		and		#0b10101111, r0h
		.else
		mov.b	@_LCD_DR, r0h
		and		#0b00010000, r0l
		and		#0b11101111, r0h
		.endif
		or.b	r0h, r0l
		mov.b	r0l, @_LCD_DR
		
		; Tas 140ns ߂Ŋm
		
		pop		er0
		rts


		; -------------------------------------------------
		; E0LLCDɏ(4bit)
		; RSM͂炩߃ZbgĂATas̃EFCgĂ邱
		; E=0̏ԂŐi邱
		; 
		;	R0L	= o̓f[^
		; o
		;	Ȃ
		; -------------------------------------------------
out_nibble:
		push	er0
		push	er1
		
		mov.b	@_LCD_DR, r0h
		and.b	#(~LCD_DR_MASK | (1 << LCD_BIT_RS)), r0h		; LCDڑĂ|[ĝωĂ͂ȂrbgɃ}XN
		and.b	#LCD_DR_DATA_MASK, r0l	; R0L̂4rbĝݗL

		mov.b	r0h, r1l				; ωf[^ r1l ɃZbg
		or.b	r0l, r1l
		bset	#LCD_BIT_E, r1l			; E=1
		mov.b	r1l, @_LCD_DR
		
		;_NOP_nSEC	450					; PWehTdsw ܂ (PWeh=450n Tdsw=140n  450n), mov/or ߂Ŋm
		
		mov.b	r0h, r1l				; ωf[^ r1l ɃZbg
		or.b	r0l, r1l				; f[^ r1l ɃZbg
		; R1L  E=0̂܂
		mov.b	r1l, @_LCD_DR
		
		;_NOP_nSEC 550					; TcycE - PWeh ܂, pop/rtsŊm

		pop	er1
		pop	er0
		rts

		; -------------------------------------------------
		; R0L(rbgOĐݒ肳Ă邱
		; 
		;	R0L	= o̓f[^
		; o
		;	Ȃ
		; -------------------------------------------------
_lcd_write_byte:
		push.w	r0
		rotl.b	r0l
		rotl.b	r0l
		rotl.b	r0l
		rotl.b	r0l
		bsr		out_nibble
		pop.w	r0
		bsr		out_nibble
		rts		

		; -------------------------------------------------
		; RS=0  R0L
		; 
		;	R0L	= o̓f[^
		; o
		;	Ȃ
		; -------------------------------------------------
		.global	_lcd_write_cmd
_lcd_write_cmd:
		jsr		_busy_test
		
		push.l	er0
		mov.b	#0b00000000, r0l
		jsr	_lcd_rs
		pop.l	er0
		bra		_lcd_write_byte
		
		; -------------------------------------------------
		; RS=1  R0L
		; 
		;	R0L	= o̓f[^
		; o
		;	Ȃ
		; -------------------------------------------------
		.global	_lcd_write_data
_lcd_write_data:
		jsr		_busy_test

		push.l	er0
		mov.b	#0b00010000, r0l
		jsr	_lcd_rs
		pop.l	er0
		bra		_lcd_write_byte
		
		.end
		
