#include "h8.h"

extern void lcd_write_cmd(H8BYTE cmd);
extern void lcd_write_data(H8BYTE cmd);

typedef unsigned char ddaddr_t;

#define	LCD_ROWS	4
#define	LCD_COLS	20
char vram[LCD_ROWS * LCD_COLS];
char vram_s[LCD_ROWS * LCD_COLS];
ddaddr_t	vram_ddram[LCD_ROWS] = { 0x00, 0x40, 0x14, 0x54 };

void lcd_locate(ddaddr_t addr)
{
	addr &= 0x7f;
	lcd_write_cmd(0x80 | addr);
}

void lcd_char(int c)
{
	c &= 0xff;
	lcd_write_data(c);
}

void lcd_clear()
{
	lcd_write_cmd(0x01);
}

void lcd_vram_update()
{
	char*	vp = vram;
	char*	sp = vram_s;
	ddaddr_t ddp;
	int		r, c;

	for (r = 0; r < LCD_ROWS; r++) {
		ddp = vram_ddram[r];
		for (c = 0; c < LCD_COLS; c++) {
			if (*vp != *sp) {
				lcd_locate(ddp);
				lcd_char(*vp);
				*sp = *vp;
			}
			vp++;
			sp++;
			ddp++;
		}
	}
}

void lcd_vram_init()
{
	io_lcd_init();
	memset(vram, ' ', sizeof(vram));
	memset(vram_s, ' ', sizeof(vram_s));
	lcd_clear();
}

int	lcd_vram_x;
int	lcd_vram_y;

void lcd_vram_cr()
{
	lcd_vram_x = 0;
}

void lcd_vram_lf()
{
	lcd_vram_y++;
}

void lcd_vram_rollup()
{
	memmove(vram, vram + LCD_COLS, (LCD_ROWS - 1) * LCD_COLS);
	memset(vram + (LCD_ROWS - 1) * LCD_COLS, ' ', LCD_COLS);
	lcd_vram_y--;
}

void lcd_vram_clear()
{
	memset(vram, ' ', sizeof(vram));
}

void lcd_vram_putchar(int c)
{
	if (c == '\n') {
		lcd_vram_lf();
	} else if (c == '\r') {
		lcd_vram_cr();
	} else if (c == '\f') {
		lcd_vram_clear();
	} else {
		if (lcd_vram_x >= LCD_COLS) {
			lcd_vram_cr();
			lcd_vram_lf();
		}
		if (lcd_vram_y >= LCD_ROWS) {
			lcd_vram_rollup();
		}
		vram[LCD_COLS * lcd_vram_y + lcd_vram_x] = (char)c;
		lcd_vram_x++;
	}
}

void lcd_vram_puts(const char* str)
{
	int c;

	while ((c = *str++) != 0)
		lcd_vram_putchar(c);
}

