#include "h8.h"
#include "baselib.h"

const char* hex4(char* buf, H8BYTE n)
{
	char* digits = "0123456789ABCDEF";
	n &= 0x0f;
	*buf = digits[n];
	buf[1] = '\0';
	return buf;
}

const char* hex8(char* buf, H8BYTE n)
{
	hex4(buf + 0, n >> 4);
	hex4(buf + 1, n);
	return buf;
}

const char* hex16(char* buf, H8WORD n)
{
	hex8(buf + 0, n >> 8);
	hex8(buf + 2, n);
	return buf;
}

const char* hex32(char* buf, H8DWORD n)
{
	hex16(buf + 0, n >> 16);
	hex16(buf + 4, n);
	return buf;
}

