#include <stddef.h>
#include "h8.h"
#include "rtc.h"
#include "i2c.h"
#include "baselib.h"

#define	RTC8564_ADDRESS	0xa2
#define	I2C_SLAVE_WRITE	0x00
#define	I2C_SLAVE_READ	0x01

#define	RTC8564_REG_SECOND	2

int rtc_cold_init()
{
	int	r, i;

	int	initval[] = {
		0x00,		// Control1
		0x00,		// Control2
		0x00,		// Seconds
		0x00,		// Minutes
		0x00,		// Hours
		0x25,		// Days
		0x02,		// Weekdays(Tuesday)
		0x03,		// Month
		0x08,		// Year
		0x80,		// Minute Alarm
		0x80,		// Hour Alarm
		0x80,		// Day Alarm
		0x80,		// Weekday Alarm
		0x00,		// CLKOUT frequency
		0x00,		// Timer control
		0x00,		// Timer
	};
	int wval;

	i2c_start();
	r = i2c_write(RTC8564_ADDRESS);
	if (r)
		return 0;
	r = i2c_write(0x00);
	if (r)
		return 0;
	for (i = 0; i < 16; i++) {
		wval = initval[i];
		r = i2c_write(wval);
		if (r)
			return 0;
	}
	i2c_stop();
	return 1;
}

static H8BYTE bcd2bin(H8BYTE n)
{
	H8BYTE h, l;
	char	buf[8];
	
	sci_puts(hex8(buf, n));
	sci_puts("\r\n");
	
	h = n >> 4;
	l = n & 0x0f;
	return h * 10 + l;
}

struct RTCTIME* rtc_getclock(struct RTCTIME* t)
{
	int	r;

	i2c_start();
	r = i2c_write(RTC8564_ADDRESS | I2C_SLAVE_WRITE);
	if (r)
		goto fail;
	r = i2c_write(RTC8564_REG_SECOND);
	if (r)
		goto fail;

	i2c_start();
	r = i2c_write(RTC8564_ADDRESS | I2C_SLAVE_READ);
	if (r)
		goto fail;
	t->second = bcd2bin(i2c_read() & 0x7f);
	i2c_ack(I2C_ACK);
	t->minute= bcd2bin(i2c_read() & 0x7f);
	i2c_ack(I2C_ACK);
	t->hour = bcd2bin(i2c_read() & 0x3f);
	i2c_ack(I2C_ACK);
	t->mday = bcd2bin(i2c_read() & 0x3f);
	i2c_ack(I2C_ACK);
	t->wday= bcd2bin(i2c_read() & 0x07);
	i2c_ack(I2C_ACK);
	t->month = bcd2bin(i2c_read() & 0x1f);
	i2c_ack(I2C_ACK);
	t->year = bcd2bin(i2c_read()) + 2000;
	i2c_ack(I2C_NACK);
	i2c_stop();
	return t;
fail:
	i2c_stop();
	return NULL;
}

int rtc_dump()
{
	int	r;
	int	i;
	char	buf[3];

	i2c_start();
	r = i2c_write(RTC8564_ADDRESS | I2C_SLAVE_WRITE);
	if (r) {
		sci_puts("write slave address failed\n");
		return 0;
	}
	r = i2c_write(0);
	if (r) {
		sci_puts("write address failed\n");
		return 0;
	}

	i2c_start(0);
	r = i2c_write(RTC8564_ADDRESS | I2C_SLAVE_READ);
	if (r) {
		sci_puts("read failed\n");
		return 0;
	}
	sci_puts("RTC");
	for (i = 0; i < 16; i++) {
		r = i2c_read();
		i2c_ack(I2C_ACK);
		sci_puts(" ");
		sci_puts(hex8(buf, r));
	}
	sci_puts("\r\n");
	i2c_stop();
	return 1;
}
