#include <stddef.h>
#include "h8.h"
#include "i2c.h"
#include "baselib.h"
#include "rtc.h"

void printd(int n)
{
	char	tmp[16];
	char*	p;

	p = tmp + sizeof(tmp);
	*--p = '\0';
	if (n == 0) {
		sci_puts("0");
		return;
	}
	while (n != 0) {
		*--p = (n % 10) + '0';
		n /= 10;
	}
	sci_puts(p);
}

int main()
{
	struct RTCTIME t;

	i2c_init();
	if (rtc_getclock(&t) == NULL) {
		sci_puts("FAILED\r\n");
		return 0;
	}

	printd(t.year);
	sci_puts("\r\n");
	printd(t.month);
	sci_puts("\r\n");
	printd(t.mday);
	sci_puts("\r\n");
	printd(t.hour);
	sci_puts("\r\n");
	printd(t.minute);
	sci_puts("\r\n");
	printd(t.second);
	sci_puts("\r\n");
	return 0;
}

