; TAB=16
#define	LED_HEARTBEAT	1
;#define	LED_LOOPBLINK	1

	include "p16f648a.inc"
	include "nmacro.inc"

	__config	_CP_OFF & _LVP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_OFF & _WDT_OFF & _INTOSC_OSC_NOCLKOUT

	ERRORLEVEL	-302

OSC_CLOCK	EQU	.60000
OSC_PRESCALER	EQU	.1	; T1CONݒlĕύXv
OSC_INTERVAL	EQU	OSC_CLOCK / OSC_PRESCALER
TIMER1_INITVAL	EQU	.65536 - OSC_INTERVAL
;TIMER1_INITVAL	EQU	.65530 - 0x130

CHAR_BLANK	EQU	0x10

SW0_PORT	EQU	PORTA
SW0_PORT_BIT	EQU	5
SW0_BIT	EQU	0
SW1_PORT	EQU	PORTB
SW1_PORT_BIT	EQU	5
SW1_BIT	EQU	1

OPM_MAX	EQU	5
	
	cblock 0x20
	W_TEMP		
	STATUS_TEMP
	T1COUNTER
	SECOND
	MINUTE
	HOUR

	SECOND_L
	SECOND_H
	MINUTE_L
	MINUTE_H
	HOUR_L
	HOUR_H
	HOUR12_L
	HOUR12_H

	DISP1
	DISP2
	DISP3
	DISP4
	SCAN_COUNTER

	DIV_NUMERATOR
	DIV_DENOM
	DIV_ANS
	DIV_MOD
	DIV_COUNTER

	SW_STATUS
	SW_STATUS_LAST
	SW_STATUS_DIFF
	SW_EDGE
	SW0_COUNTER
	SW1_COUNTER

	INPUT_EVENT

	OPERATION_MODE
	OPERATION_MODE_TEMP

	SW_STATUS_SAVE
	SW_EDGE_SAVE

	MOD_HOUR
	MOD_MINUTE

	INTR_REENT

	endc

	org	0x00
	goto	main
	org	0x04
	goto	intr

getbit:	addwf	PCL, F
	retlw	b'00000001'
	retlw	b'00000010'
	retlw	b'00000100'
	retlw	b'00001000'
	retlw	b'00010000'
	retlw	b'00100000'
	retlw	b'01000000'
	retlw	b'10000000'

getdigit:
	addwf	PCL, F
	; 7ZOf[^a=b7, b=b6, c=b4, d=b3 e=b2, f=b1, g=bit0
	; b5͖lȂ̂Œ(RA5͐p̂ߔ΂Ă)
	retlw	b'11011110'	; 0
	retlw	b'01010000'	; 1
	retlw	b'11001101'	; 2
	retlw	b'11011001'	; 3
	retlw	b'01010011'	; 4
	retlw	b'10011011'	; 5
	retlw	b'10011111'	; 6
	retlw	b'11010000'	; 7
	retlw	b'11011111'	; 8
	retlw	b'11011011'	; 9
	retlw	b'11010111'	; A
	retlw	b'00011111'	; B
	retlw	b'10001110'	; C
	retlw	b'01011101'	; D
	retlw	b'10001111'	; E
	retlw	b'10000111'	; F
	retlw	b'00000000'	; uN(CHAR_BLANK萔ƈv邱)
;
; PCLCH𑀍삵Ȃ悤ɂ邽߁ÃAhX 0x100 𒴂Ȃ
;

intr:
	intr_start

	btfsc	PIR1, TMR1IF
	call	isr_timer1

	btfsc	INTCON, T0IF
	CALL	isr_timer0
	intr_end
	RETFIE

init_timer0:
	bcf	STATUS, RP0
	bcf	INTCON, T0IF
	return

isr_timer0:
	btfsc	INTR_REENT, 0
	return
	bsf	INTR_REENT, 0

	call	init_timer0
	enable_interrupt
	
	call	scan_common
	call	sw_poll

	bcf	INTR_REENT, 0
	return

init_timer1:
	bcf	STATUS, RP0
	movlw	HIGH TIMER1_INITVAL
	movwf	TMR1H
	movlw	LOW TIMER1_INITVAL
	movwf	TMR1L
	bcf	PIR1, TMR1IF
	return

isr_timer1:
	call	init_timer1
	call	tic_one_sec
	call	update_clock
	return


;
; bɈĂяoTu[`
;
tic_one_sec:
	ifdef LED_HEARTBEAT
	banksel	PORTA
	movlw	b'00010000'
	xorwf	PORTB, f
	endif

	incf	SECOND, f
	movlw	.60
	subwf	SECOND, w
	btfss	STATUS, Z
	return
next_minute:
	clrf	SECOND
next_minute_keep_second:
	incf	MINUTE, f
	movlw	.60
	subwf	MINUTE, w
	btfss	STATUS, Z
	return

next_hour:
	clrf	MINUTE
next_hour_keep_minute:
	incf	HOUR, f
	movlw	.24
	subwf	HOUR, w
	btfss	STATUS, Z
	return
	clrf	HOUR

	return

scan_common:
	banksel	PORTA

	movlw	0x0f
	iorwf	PORTB, f	; Am[hRCSH(OFF)

	movlw	DISP1
	movwf	FSR
	movfw	SCAN_COUNTER
	addwf	FSR, F
	movfw	INDF
	
	call	getdigit	; digit to 7seg bits
	xorlw	0xff	; rbg](L̃ZOg_)
	movwf	PORTA	; 7ZOf[^

	movf	SCAN_COUNTER, w
	call	getbit	; XLJE^̃}XNrbg (1 << SCAN_COUNTER)
	xorwf	PORTB, F	; }XNrbg](őSHɂȂĂ̂Ń}XNrbĝL)

	incf	SCAN_COUNTER, F
	movlw	b'00000011'
	andwf	SCAN_COUNTER, F
	return

SW_COUNTER_VALUE	EQU	.10
	
sw_poll:	
	clrf	SW_STATUS
	btfsc	SW0_PORT, SW0_PORT_BIT
	bsf	SW_STATUS, SW0_BIT
	btfsc	SW1_PORT, SW1_PORT_BIT
	bsf	SW_STATUS, SW1_BIT

	movfw	SW_STATUS
	xorwf	SW_STATUS_LAST, w
	movwf	SW_STATUS_DIFF

	movlw	SW_COUNTER_VALUE	
	btfsc	SW_STATUS_DIFF, SW0_BIT
	movwf	SW0_COUNTER
	btfsc	SW_STATUS_DIFF, SW1_BIT
	movwf	SW1_COUNTER

	clrf	SW_EDGE

	movfw	SW0_COUNTER
	btfsc	STATUS, Z
	goto	s1
	bsf	SW_EDGE, SW0_BIT
	decfsz	SW0_COUNTER, F
	bcf	SW_EDGE, SW0_BIT
s1:	

	movfw	SW1_COUNTER
	btfsc	STATUS, Z
	goto	s2
	bsf	SW_EDGE, SW1_BIT
	decfsz	SW1_COUNTER, F
	bcf	SW_EDGE, SW1_BIT
s2:	

	movfw	SW_STATUS
	movwf	SW_STATUS_LAST

	return


; 8rbgZ
; DIV_NUMERATOR / DIV_DENOM = DIV_ANS ܂ DIV_MOD
div:
	movfw	DIV_NUMERATOR
	movwf	DIV_ANS
	movlw	8
	movwf	DIV_COUNTER
	clrf	DIV_MOD
div_0:	
	bcf		STATUS, C
	rlf		DIV_ANS, F
	rlf		DIV_MOD, F

	movfw	DIV_DENOM
	subwf	DIV_MOD, W
	btfss	STATUS, C
	goto	div_1
	bsf		DIV_ANS, 0
	movwf	DIV_MOD
div_1:
	decfsz	DIV_COUNTER, F
	goto	div_0

	return

; ݂̎LED\RAMɃZbg
update_clock:
	movfw	HOUR
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	HOUR_H
	movfw	DIV_MOD
	movwf	HOUR_L

	movfw	HOUR
	movwf	DIV_NUMERATOR
	movlw	.12
	movwf	DIV_DENOM
	call	div
	movfw	DIV_MOD
	btfsc	STATUS, Z
	movlw	.12	; 12ԕ\0012ƕ\
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	HOUR12_H
	movfw	DIV_MOD
	movwf	HOUR12_L

	movfw	MINUTE
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	MINUTE_H
	movfw	DIV_MOD
	movwf	MINUTE_L

	movfw	SECOND
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	SECOND_H
	movfw	DIV_MOD
	movwf	SECOND_L

	movfw	OPERATION_MODE
	addwf	PCL, F
	goto	update_clock_12h
	goto	update_clock_24h
	goto	update_clock_minsec
	goto	modify_hour
	goto	modify_minute

update_clock_minsec:
	movfw	MINUTE_H
	movwf	DISP1
	movfw	MINUTE_L
	movwf	DISP2
	movfw	SECOND_H
	movwf	DISP3
	movfw	SECOND_L
	movwf	DISP4
	return

update_clock_24h:
	movfw	HOUR_H
	btfsc	STATUS, Z
	movlw	CHAR_BLANK
	movwf	DISP1
	movfw	HOUR_L
	movwf	DISP2
	movfw	MINUTE_H
	movwf	DISP3
	movfw	MINUTE_L
	movwf	DISP4
	return

update_clock_12h:
	movfw	HOUR12_H
	btfsc	STATUS, Z
	movlw	CHAR_BLANK
	movwf	DISP1
	movfw	HOUR12_L
	movwf	DISP2
	movfw	MINUTE_H
	movwf	DISP3
	movfw	MINUTE_L
	movwf	DISP4
	return

modify_minute:
	movlw	CHAR_BLANK
	movwf	DISP1
	movwf	DISP2
	movfw	MINUTE_H
	movwf	DISP3
	movfw	MINUTE_L
	movwf	DISP4
	return

modify_hour:
	movfw	HOUR_H
	movwf	DISP1
	movfw	HOUR_L
	movwf	DISP2
	movlw	CHAR_BLANK
	movwf	DISP3
	movwf	DISP4
	return

main:
	clrf	INTR_REENT
	clrf	INPUT_EVENT
	clrf	SECOND
	clrf	MINUTE
	clrf	HOUR

	clrf	DISP1
	clrf	DISP2
	clrf	DISP3
	clrf	DISP4
	
	clrf	SW_STATUS
	clrf	SW_STATUS_LAST

	movlw	SW_COUNTER_VALUE
	movwf	SW0_COUNTER
	movwf	SW1_COUNTER

	movlw	2
	movwf	OPERATION_MODE

	clrf	SCAN_COUNTER

	banksel	CMCON
	movlw	0x07
	movwf	CMCON

	banksel	VRCON
	clrf	VRCON

	bcf	STATUS, RP0
	; PORTA b`@SZOgOFF
	movlw	b'11011111'
	movwf	PORTA

	; PORTB b`@SXLOFF, RB4(CWP[^[LED OFF)
	movlw	b'00001111'
	movwf	PORTB


	bsf	STATUS, RP0

	movlw	b'11100000'
	movwf	TRISB

	movlw	b'00100000'
	movwf	TRISA

	bcf	STATUS, RP0
	btfsc	SW0_PORT, SW0_PORT_BIT
	goto	test_pattern_1

	bsf	STATUS, RP0

	bsf	PIE1, TMR1IE

	bcf	STATUS, RP0
	movlw	b'00001111'	; OIV[^[ 1/1 vXP[
	;movlw	b'00111111'	; OIV[^[ 1/8 vXP[
	movwf	T1CON

	bcf	STATUS, RP0
	bcf	INTCON, GIE	; 荞݋֎~(ݒ蒆)
	bsf	INTCON, PEIE	; Ӌ@튄荞ݗL(Timer1)
	bsf	INTCON, T0IE	; Timer0荞ݗL

	banksel	OPTION_REG
	movlw	b'11000010'	; Timer0 internal clock 1:8 prescaler(Ȃ) 1:16ł͂
;	movlw	b'11000111'	; Timer0 internal clock 1:256 prescaler(Ȃ) 1:16ł͂
	movwf	OPTION_REG

	call	init_timer1
	call	init_timer0

	bcf	STATUS, RP0
	bsf	INTCON, GIE	; 荞݋

	call	update_clock

loop:
	bcf	INTCON, GIE	; 荞݋֎~
	movfw	SW_EDGE
	movwf	SW_EDGE_SAVE
	movfw	SW_STATUS
	movwf	SW_STATUS_SAVE
	bsf	INTCON, GIE	; 荞݋


	btfss	SW_EDGE_SAVE, SW0_BIT
	goto	sw0_noact
	
	btfss	SW_STATUS_SAVE, SW0_BIT
	goto	sw0_noact

	incf	OPERATION_MODE, F
	movlw	OPM_MAX
	subwf	OPERATION_MODE, w
	btfsc	STATUS, C
	clrf	OPERATION_MODE
	call	update_clock
	bcf	SW_EDGE, SW0_BIT
sw0_noact:
	btfss	SW_EDGE_SAVE, SW1_BIT
	goto	sw1_noact
	
	btfss	SW_STATUS_SAVE, SW1_BIT
	goto	sw1_noact

	bcf	SW_EDGE, SW1_BIT

	movlw	0
	subwf	OPERATION_MODE, W
	btfsc	STATUS, Z
	goto	reset_second ; 12h[hł̉E{^:b̃Zbg
	movlw	1
	subwf	OPERATION_MODE, W
	btfsc	STATUS, Z
	goto	reset_second; 24h[hł̉E{^:b̃Zbg
	movlw	2
	subwf	OPERATION_MODE, W
	btfsc	STATUS, Z
	goto	reset_second; b[hł̉E{^:b̃Zbg
	movlw	3
	subwf	OPERATION_MODE, W
	btfsc	STATUS, Z
	goto	adjust_hour; ύX[hł̉E{^:CNg
	movlw	4
	subwf	OPERATION_MODE, W
	btfsc	STATUS, Z
	goto	adjust_minute; ύX[hł̉E{^:CNg
sw1_noact:
	goto	loop

reset_second:
	disable_interrupt
	movlw	.30
	subwf	SECOND, w
	btfsc	STATUS, C
	call	next_minute
	clrf	SECOND
	call	update_clock
	call	init_timer1
	enable_interrupt
	goto	loop

adjust_hour:
	disable_interrupt
	call	next_hour_keep_minute
	call	update_clock
	enable_interrupt
	goto	loop

adjust_minute:
	disable_interrupt
	call	next_minute_keep_second
	call	update_clock
	enable_interrupt
	goto	loop

test_pattern_1:
	banksel	PORTA
	clrf	PORTA
	movlw	b'00001110'
	movwf	PORTB
test_pattern_1_1:
	goto	test_pattern_1_1

	end
