; TAB=16
#define	LED_HEARTBEAT	1
;#define	LED_LOOPBLINK	1

	include "p16f648a.inc"
	include "nmacro.inc"

	__config	_CP_OFF & _LVP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_OFF & _WDT_OFF & _INTOSC_OSC_NOCLKOUT

	ERRORLEVEL	-302

PORTA_TEST_PAT	EQU	b'00001110'
PORTB_TEST_PAT	EQU	b'00100000'

INIT_CMCON	EQU	b'00000111'
INIT_VRCON	EQU	b'00000000'
INIT_PORTA	EQU	b'11111111'
INIT_PORTB	EQU	b'11101111'
INIT_TRISA	EQU	b'01110000'
INIT_TRISB	EQU	b'00100000'
INIT_OPTION_REG	EQU	b'00100110'	; Timer0 internal clock 1:128

PORT_SEGMENT	EQU	PORTB
PORT_COLUMN	EQU	PORTA
PORT_COLUMN_MASK	EQU	0x0f	; Jb0-b3܂


HEARTBEAT_PORT	EQU	PORTA
HEARTBEAT_BIT	EQU	7

CHAR_BLANK	EQU	0x10

SW0_PORT	EQU	PORTA
SW0_PORT_BIT	EQU	5
SW0_BIT	EQU	0
SW1_PORT	EQU	PORTB
SW1_PORT_BIT	EQU	5
SW1_BIT	EQU	1

OPM_MAX	EQU	5
	
	cblock 0x20
	W_TEMP		
	STATUS_TEMP
	T1COUNTER

	SECOND_16TH
	SECOND
	MINUTE
	HOUR

	COLUMN0
	COLUMN1
	COLUMN2
	COLUMN3
	SCAN_COUNTER

	DIV_NUMERATOR
	DIV_DENOM
	DIV_ANS
	DIV_MOD
	DIV_COUNTER

	SW_STATUS
	SW_STATUS_LAST
	SW_STATUS_DIFF
	SW_EDGE

	SW0_COUNTER
	SW1_COUNTER

	OPERATION_MODE
	OPERATION_MODE_TEMP

	SW_STATUS_SAVE
	SW_EDGE_SAVE

	MOD_HOUR
	MOD_MINUTE

	WAIT_COUNTER

	NEW_MODE	
	EDIT_VALUE
	DISPATCH_ACTION
	endc

	org	0x00
	goto	main
	org	0x04
	goto	intr

getbit:	addwf	PCL, F
	retlw	b'00000001'
	retlw	b'00000010'
	retlw	b'00000100'
	retlw	b'00001000'
	retlw	b'00010000'
	retlw	b'00100000'
	retlw	b'01000000'
	retlw	b'10000000'

getdigit:
	addwf	PCL, F
	; 7ZOf[^a=b7, b=b6, c=b4, d=b3 e=b2, f=b1, g=bit0
	; b5͖lȂ̂Œ(RA5͐p̂ߔ΂Ă)
	retlw	b'11011110'	; 0
	retlw	b'01010000'	; 1
	retlw	b'11001101'	; 2
	retlw	b'11011001'	; 3
	retlw	b'01010011'	; 4
	retlw	b'10011011'	; 5
	retlw	b'10011111'	; 6
	retlw	b'11010000'	; 7
	retlw	b'11011111'	; 8
	retlw	b'11011011'	; 9
	retlw	b'11010111'	; A
	retlw	b'00011111'	; B
	retlw	b'10001110'	; C
	retlw	b'01011101'	; D
	retlw	b'10001111'	; E
	retlw	b'10000111'	; F
	retlw	b'00000000'	; uN(CHAR_BLANK萔ƈv邱)

DISPATCH_ENTER	EQU	0
DISPATCH_LEAVE	EQU	1
DISPATCH_SW0	EQU	2
DISPATCH_SW1	EQU	3
DISPATCH_TIC	EQU	4

mode_24h:
	movfw	DISPATCH_ACTION
	addwf	PCL, F
	goto	mode_24h_enter
	goto	mode_24h_leave
	goto	mode_24h_sw0
	goto	mode_24h_sw1
	goto	mode_24h_tic

mode_12h:
	movfw	DISPATCH_ACTION
	addwf	PCL, F
	goto	mode_12h_enter
	goto	mode_12h_leave
	goto	mode_12h_sw0
	goto	mode_12h_sw1
	goto	mode_12h_tic

mode_ms:
	movfw	DISPATCH_ACTION
	addwf	PCL, F
	goto	mode_mmss_enter
	goto	mode_mmss_leave
	goto	mode_mmss_sw0
	goto	mode_mmss_sw1
	goto	mode_mmss_tic

mode_hadj:
	movfw	DISPATCH_ACTION
	addwf	PCL, F
	goto	mode_hadj_enter
	goto	mode_hadj_leave
	goto	mode_hadj_sw0
	goto	mode_hadj_sw1
	goto	mode_hadj_tic

mode_madj:
	movfw	DISPATCH_ACTION
	addwf	PCL, F
	goto	mode_madj_enter
	goto	mode_madj_leave
	goto	mode_madj_sw0
	goto	mode_madj_sw1
	goto	mode_madj_tic


MODE_CLOCK_12H	EQU	0
MODE_CLOCK_24H	EQU	1
MODE_CLOCK_MMSS	EQU	2
MODE_HADJ	EQU	3
MODE_MADJ	EQU	4

dispatch:
	movwf	DISPATCH_ACTION
	movfw	OPERATION_MODE
	addwf	PCL, F
	goto	mode_12h
	goto	mode_24h
	goto	mode_ms
	goto	mode_hadj
	goto	mode_madj

;
; PCLCH𑀍삵Ȃ悤ɂ邽߁ÃAhX 0x100 𒴂Ȃ
;

intr:
	intr_start
	banksel	PIR1
	btfsc	PIR1, TMR1IF
	CALL	isr_timer1
	btfsc	INTCON, T0IF
	CALL	isr_timer0
	intr_end
	RETFIE

init_timer0:
	bcf	STATUS, RP0
	bcf	INTCON, T0IF
	return

isr_timer0:
	banksel	HEARTBEAT_PORT
	movlw	1 << HEARTBEAT_BIT
	xorwf	HEARTBEAT_PORT, f
	call	tic_one_sec
	movlw	DISPATCH_TIC
	call	dispatch
	call	init_timer0
	return

init_timer1:
	clrf	TMR1L
	movlw	0xf0
	movwf	TMR1H
	bcf	PIR1, TMR1IF
	return

isr_timer1:
	call	scan_common
	call	sw_poll
	call	init_timer1
	return

tic_16th_second:
	incf	SECOND_16TH, F
	movlw	.16
	subwf	SECOND_16TH, W
	btfss	STATUS, Z
	return
tic_one_sec:
	clrf	SECOND_16TH
tic_one_sec_keep_16th:
	incf	SECOND, f
	movlw	.60
	subwf	SECOND, w
	btfss	STATUS, Z
	return
next_minute:
	clrf	SECOND
next_minute_keep_second:
	incf	MINUTE, f
	movlw	.60
	subwf	MINUTE, w
	btfss	STATUS, Z
	return

next_hour:
	clrf	MINUTE
next_hour_keep_minute:
	incf	HOUR, f
	movlw	.24
	subwf	HOUR, w
	btfss	STATUS, Z
	return
	clrf	HOUR

	return

scan_common:
	banksel	PORT_SEGMENT

	movlw	PORT_COLUMN_MASK
	iorwf	PORT_COLUMN, f	; Am[hRCSH(OFF)

	movlw	COLUMN0
	movwf	FSR
	movfw	SCAN_COUNTER
	addwf	FSR, F
	movfw	INDF
	
	call	getdigit	; digit to 7seg bits
	xorlw	0xff	; rbg](L̃ZOg_)
	movwf	PORT_SEGMENT	; 7ZOf[^

	movf	SCAN_COUNTER, w
	call	getbit	; XLJE^̃}XNrbg (1 << SCAN_COUNTER)
	xorwf	PORT_COLUMN, F	; }XNrbg](őSHɂȂĂ̂Ń}XNrbĝL)

	incf	SCAN_COUNTER, F
	movlw	b'00000011'
	andwf	SCAN_COUNTER, F
	return

SW_COUNTER_VALUE	EQU	.10
	
sw_poll:	
	clrf	SW_STATUS
	btfsc	SW0_PORT, SW0_PORT_BIT
	bsf	SW_STATUS, SW0_BIT
	btfsc	SW1_PORT, SW1_PORT_BIT
	bsf	SW_STATUS, SW1_BIT

	movfw	SW_STATUS
	xorwf	SW_STATUS_LAST, w
	movwf	SW_STATUS_DIFF

	movlw	SW_COUNTER_VALUE	
	btfsc	SW_STATUS_DIFF, SW0_BIT
	movwf	SW0_COUNTER
	btfsc	SW_STATUS_DIFF, SW1_BIT
	movwf	SW1_COUNTER

	clrf	SW_EDGE

	movfw	SW0_COUNTER
	btfsc	STATUS, Z
	goto	s1
	bsf	SW_EDGE, SW0_BIT
	decfsz	SW0_COUNTER, F
	bcf	SW_EDGE, SW0_BIT
s1:	

	movfw	SW1_COUNTER
	btfsc	STATUS, Z
	goto	s2
	bsf	SW_EDGE, SW1_BIT
	decfsz	SW1_COUNTER, F
	bcf	SW_EDGE, SW1_BIT
s2:	

	movfw	SW_STATUS
	movwf	SW_STATUS_LAST

	return


; 8rbgZ
; DIV_NUMERATOR / DIV_DENOM = DIV_ANS ܂ DIV_MOD
div:
	movfw	DIV_NUMERATOR
	movwf	DIV_ANS
	movlw	8
	movwf	DIV_COUNTER
	clrf	DIV_MOD
div_0:	
	bcf		STATUS, C
	rlf		DIV_ANS, F
	rlf		DIV_MOD, F

	movfw	DIV_DENOM
	subwf	DIV_MOD, W
	btfss	STATUS, C
	goto	div_1
	bsf		DIV_ANS, 0
	movwf	DIV_MOD
div_1:
	decfsz	DIV_COUNTER, F
	goto	div_0

	return


main:
	; ϐ
	clrf	SECOND_16TH
	clrf	SECOND
	clrf	MINUTE
	clrf	HOUR

	clrf	COLUMN0
	clrf	COLUMN1
	clrf	COLUMN2
	clrf	COLUMN3
	
	clrf	SW_STATUS
	clrf	SW_STATUS_LAST

	movlw	SW_COUNTER_VALUE
	movwf	SW0_COUNTER
	movwf	SW1_COUNTER

	movlw	2
	movwf	OPERATION_MODE

	clrf	SCAN_COUNTER

	; Special Register 
	banksel	OPTION_REG
	movlw	INIT_OPTION_REG
	movwf	OPTION_REG

	banksel	CMCON
	movlw	INIT_CMCON
	movwf	CMCON

	banksel	VRCON
	movlw	INIT_VRCON
	movwf	VRCON

	bcf	STATUS, RP0
	movlw	INIT_PORTA
	movwf	PORTA
	movlw	INIT_PORTB
	movwf	PORTB

	bsf	STATUS, RP0

	movlw	INIT_TRISA
	movwf	TRISA

	movlw	INIT_TRISB
	movwf	TRISB

	bcf	STATUS, RP0
	btfsc	SW0_PORT, SW0_PORT_BIT
	goto	test_pattern_1

	banksel	T1CON
	movlw	b'00000001'
	movwf	T1CON	

	bsf	STATUS, RP0
	bsf	PIE1, TMR1IE

	bcf	STATUS, RP0
	bcf	INTCON, GIE	; 荞݋֎~(ݒ蒆)
	bsf	INTCON, T0IE	; Timer0荞ݗL
	bsf	INTCON, PEIE	; Timer0荞ݗL


	call	init_timer0
	call	init_timer1

	bcf	STATUS, RP0
	bsf	INTCON, GIE	; 荞݋


loop:
	bcf	INTCON, GIE	; 荞݋֎~
	movfw	SW_EDGE
	movwf	SW_EDGE_SAVE
	movfw	SW_STATUS
	movwf	SW_STATUS_SAVE
	bsf	INTCON, GIE	; 荞݋


	btfss	SW_EDGE_SAVE, SW0_BIT
	goto	sw0_noact
	btfss	SW_STATUS_SAVE, SW0_BIT
	goto	sw0_noact
	movlw	DISPATCH_SW0
	call	dispatch
	bcf	SW_EDGE, SW0_BIT
sw0_noact:

	btfss	SW_EDGE_SAVE, SW1_BIT
	goto	sw1_noact
	btfss	SW_STATUS_SAVE, SW1_BIT
	goto	sw1_noact
	movlw	DISPATCH_SW1
	call	dispatch
	bcf	SW_EDGE, SW1_BIT
sw1_noact:
	goto	loop

reset_second:
	disable_interrupt
	movlw	.30
	subwf	SECOND, w
	btfsc	STATUS, C
	call	next_minute
	clrf	SECOND
	movlw	DISPATCH_TIC
	call	dispatch
	enable_interrupt
	goto	loop

test_pattern_1:
	bcf	STATUS, RP0
	movlw	PORTA_TEST_PAT
	movwf	PORTA
	movlw	PORTB_TEST_PAT
	movwf	PORTB
test_pattern_1_1:
	goto	test_pattern_1_1

set_column01:
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	COLUMN0
	movfw	DIV_MOD
	movwf	COLUMN1
	return

set_column01_zs:
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	btfsc	STATUS, Z
	movlw	CHAR_BLANK
	movwf	COLUMN0
	movfw	DIV_MOD
	movwf	COLUMN1
	return

set_column23:
	movwf	DIV_NUMERATOR
	movlw	.10
	movwf	DIV_DENOM
	call	div
	movfw	DIV_ANS
	movwf	COLUMN2
	movfw	DIV_MOD
	movwf	COLUMN3
	return

transit_mode:	
	movwf	NEW_MODE
	movlw	DISPATCH_LEAVE
	call	dispatch
	movfw	NEW_MODE
	movwf	OPERATION_MODE
	movlw	DISPATCH_ENTER
	call	dispatch
	return

mode_12h_enter:
	goto	mode_12h_disp
mode_12h_leave:
	return
mode_12h_sw0:
	movlw	MODE_CLOCK_24H
	goto	transit_mode
mode_12h_sw1:
	goto	reset_second
mode_12h_disp:
mode_12h_tic:
	movlw	.12
	subwf	HOUR, W
	btfss	STATUS, C
	movfw	HOUR
	call	set_column01_zs
	movfw	MINUTE
	call	set_column23
	return

mode_24h_enter:
	goto	mode_24h_disp
mode_24h_leave:
	return
mode_24h_sw0:
	movlw	MODE_CLOCK_MMSS
	goto	transit_mode
mode_24h_sw1:
	goto	reset_second
mode_24h_disp:
mode_24h_tic:
	movfw	HOUR
	call	set_column01_zs
	movfw	MINUTE
	call	set_column23
	return

mode_mmss_enter:
	goto	mode_mmss_disp
mode_mmss_leave:
	return
mode_mmss_sw0:
	movlw	MODE_HADJ
	goto	transit_mode
mode_mmss_sw1:
	goto	reset_second
mode_mmss_disp:
mode_mmss_tic:
	movfw	MINUTE
	call	set_column01
	movfw	SECOND
	call	set_column23
	return

mode_hadj_enter:	
	movlw	CHAR_BLANK
	movwf	COLUMN2
	movwf	COLUMN3
	movfw	HOUR
	movwf	EDIT_VALUE
	goto	mode_hadj_disp
mode_hadj_leave:
	movfw	EDIT_VALUE
	movwf	HOUR
	return
mode_hadj_sw0:
	movlw	MODE_MADJ
	goto	transit_mode
mode_hadj_sw1:
	incf	EDIT_VALUE, F
	movlw	.24
	subwf	EDIT_VALUE, w
	btfsc	STATUS, Z
	clrf	EDIT_VALUE
mode_hadj_disp:
	movfw	EDIT_VALUE
	call	set_column01
	return
mode_hadj_tic:	
	return

mode_madj_enter:
	movlw	CHAR_BLANK
	movwf	COLUMN0
	movwf	COLUMN1
	movfw	MINUTE
	movwf	EDIT_VALUE
	goto	mode_madj_disp
mode_madj_leave:
	movfw	EDIT_VALUE
	movwf	MINUTE
	return
mode_madj_sw0:
	movlw	MODE_CLOCK_12H
	goto	transit_mode
mode_madj_sw1:
	incf	EDIT_VALUE, F
	movlw	.60
	subwf	EDIT_VALUE, w
	btfsc	STATUS, Z
	clrf	EDIT_VALUE
mode_madj_disp:
	movfw	EDIT_VALUE
	call	set_column23
	return
mode_madj_tic:
	return

	end
