// ByteBuffer.h : Declaration of the CByteBuffer

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif


// CByteBuffer

class ATL_NO_VTABLE CByteBuffer :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CByteBuffer, &CLSID_ByteBuffer>,
	public IDispatchImpl<IByteBuffer, &__uuidof(IByteBuffer), &LIBID_NWriterObjectsLib, /* wMajor = */ 1, /* wMinor = */ 0>,
	public IBufferPtr
{
public:
	CByteBuffer()
	{
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_BYTEBUFFER)


	BEGIN_COM_MAP(CByteBuffer)
		COM_INTERFACE_ENTRY2(IDispatch, IByteBuffer)
		COM_INTERFACE_ENTRY(IByteBuffer)
		COM_INTERFACE_ENTRY(IBufferPtr)
	END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		m_buffer = NULL;
		m_buffer_size = 0;
		m_current = NULL;

		return S_OK;
	}

	void FinalRelease()
	{
		delete m_buffer;
	}

public:


	BYTE*	m_buffer;
	LONG	m_buffer_size;
	LONG	m_current;

	// IByteBuffer Methods
public:
	STDMETHOD(get_Item)( LONG Index,  LONG * pVal)
	{
		if (m_buffer == NULL)
			return E_UNEXPECTED;
		if (Index < 0 || Index >= m_buffer_size)
			return E_INVALIDARG;
		if (pVal == NULL)
			return E_POINTER;
		*pVal = m_buffer[Index];
		return S_OK;
	}
	STDMETHOD(put_Item)( LONG Index,  LONG newVal)
	{
		if (m_buffer == NULL)
			return E_UNEXPECTED;
		if (Index < 0 || Index >= m_buffer_size)
			return E_INVALIDARG;
		m_buffer[Index] = (BYTE)newVal;
		return S_OK;
	}
	STDMETHOD(Rewind)()
	{
		m_current = 0;
		return S_OK;
	}
	STDMETHOD(Allocate)( LONG ByteSize)
	{
		if (ByteSize < 0)
			return E_INVALIDARG;
		m_buffer_size = 0;
		m_current = 0;
		delete m_buffer;
		m_buffer = new BYTE[ByteSize];
		if (m_buffer == NULL) {
			return E_OUTOFMEMORY;
		}

		memset(m_buffer, 0, ByteSize);
		m_current = 0;
		m_buffer_size = ByteSize;
		return S_OK;
	}
	STDMETHOD(get_CurrentIndex)( LONG * pVal)
	{
		if (pVal == NULL)
			return E_POINTER;
		*pVal = m_current;
		return S_OK;
	}
	STDMETHOD(put_CurrentIndex)( LONG newVal)
	{
		if (newVal < 0 || newVal >= m_buffer_size)
			newVal = m_buffer_size;
		m_current = newVal;
		return S_OK;
	}
	STDMETHOD(Add)( LONG Value)
	{
		if (m_current >= m_buffer_size)
			return E_UNEXPECTED;
		if (m_buffer == NULL)
			return E_UNEXPECTED;
		m_buffer[m_current++] = (BYTE)Value;
		return S_OK;
	}
	STDMETHOD(GetPointer)( BYTE * * ppPointer, LONG* pSize)
	{
		if (ppPointer == NULL || pSize == NULL)
			return E_POINTER;
		if (m_buffer == NULL)
			return E_UNEXPECTED;
		*ppPointer = m_buffer;
		*pSize = m_buffer_size;
		return S_OK;
	}
	STDMETHOD(Get)(LONG* rValue);
};

OBJECT_ENTRY_AUTO(__uuidof(ByteBuffer), CByteBuffer)
