// ComPort.h : Declaration of the CComPort

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CComPort

class ATL_NO_VTABLE CComPort :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CComPort, &CLSID_ComPort>,
	public ISupportErrorInfo,
	public IDispatchImpl<IComPort, &IID_IComPort, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CComPort()
	{
		m_hComm = INVALID_HANDLE_VALUE;
		m_rindex = 0;
		m_rlen = 0;
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_COMPORT)


	BEGIN_COM_MAP(CComPort)
		COM_INTERFACE_ENTRY(IComPort)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
	END_COM_MAP()

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		Close();
	}

protected:
	HANDLE	m_hComm;
	int		m_rindex;
	int		m_rlen;
	char	m_rbuf[1024];
public:
	HRESULT FillBuf();
	STDMETHOD(Open)(BSTR szDefString);
	STDMETHOD(Close)();
	STDMETHOD(PeekChar)(SHORT * c);
	STDMETHOD(ReadChar)(SHORT * c);
	STDMETHOD(WriteChar)(SHORT c);

	STDMETHOD(WriteString)(BSTR strOut);

	// IComPortRaw Methods
public:
	STDMETHOD(Read)(BYTE * buf, DWORD cbbuf, DWORD * rbytes);
	STDMETHOD(Write)(BYTE* buf, ULONG size, ULONG* wbytes);
};

OBJECT_ENTRY_AUTO(__uuidof(ComPort), CComPort)
