// DeviceProfile.cpp : Implementation of CDeviceProfile

#include "stdafx.h"
#include "DeviceProfile.h"
#include "ProfileValues.h"
#include "../pww/nwutil.h"


// CDeviceProfile
STDMETHODIMP CDeviceProfile::get_Item(BSTR Name, BSTR* pVal)
{
	wchar_t section[1024];
	wchar_t buf[1024];
	const wchar_t* bad_string = L"\x01";
	set<wstring> used;

	wcscpy(section, m_SectionName);
	while (true) {
		FPGetPrivateProfileString(section, Name, bad_string, buf, sizeof(buf), m_Filename);
		if (wcscmp(buf, bad_string) != 0) {
			*pVal = SysAllocString(buf);
			return S_OK;
		}
		FPGetPrivateProfileString(section, L"Next", bad_string, buf, sizeof(buf), m_Filename);
		if (wcscmp(buf, bad_string) == 0) {
			break;
		}
		if (used.find(buf) != used.end())
			break;
		wcscpy(section, buf);
		used.insert(section);
	}
	return E_FAIL;
}

STDMETHODIMP CDeviceProfile::put_Filename(BSTR newVal)
{
	m_Filename = newVal;
	return S_OK;
}

STDMETHODIMP CDeviceProfile::put_SectionName(BSTR newVal)
{
	m_SectionName = newVal;
	return S_OK;
}

STDMETHODIMP CDeviceProfile::Int(BSTR Index, LONG* pValue)
{
	HRESULT r;
	CComBSTR	strval;
	wchar_t*	ep;
	LONG		lval;

	if (pValue == NULL)
		return E_POINTER;

	r = get_Item(Index, &strval);
	if (FAILED(r))
		return r;
	lval = wcstol(strval, &ep, 0);
	while (*ep != '\0') {
		if (!iswspace(*ep))
			return E_FAIL;
		ep++;
	}
	*pValue = lval;
	return S_OK;
}

STDMETHODIMP CDeviceProfile::get_ArrayVal(BSTR Key, AVTVAL nType, IProfileValues** pVal)
{
	CProfileValues* retval;
	CComBSTR	strval;
	HRESULT		r;
	list<wstring> tmplist;

	if (Key == NULL || pVal == NULL)
		return E_POINTER;

	r = get_Item(Key, &strval);
	if (FAILED(r))
		return r;

	retval = new CComObject<CProfileValues>;
	split(tmplist, strval, L",");
	while (tmplist.size()) {
		CComVariant v;

		const wstring& str = tmplist.front();
		switch (nType) {
		case AVT_STRING:
			v.vt = VT_BSTR;
			v.bstrVal = SysAllocString(str.c_str());
			retval->m_coll.push_back(v);
			break;
		case AVT_INTEGER:
			v.vt = VT_I4;
			v.lVal = wcstoul(str.c_str(), NULL, 0);
			retval->m_coll.push_back(v);
			break;
		case AVT_DOUBLE:
			v.vt = VT_R8;
			v.dblVal = _wtof(str.c_str());
			retval->m_coll.push_back(v);
			break;
		default:
			delete retval;
			return E_INVALIDARG;
		}
		tmplist.pop_front();
	}
	retval->AddRef();
	*pVal = retval;
	return S_OK;
}

STDMETHODIMP CDeviceProfile::get_BaseDir(BSTR* pVal)
{
	*pVal = m_basedir.Copy();
	return S_OK;
}

STDMETHODIMP CDeviceProfile::put_BaseDir(BSTR newVal)
{
	m_basedir = newVal;
	return S_OK;
}


void CDeviceProfile::FPGetPrivateProfileString(LPCWSTR Section, LPCWSTR Name, LPCWSTR defstr, LPWSTR buf, DWORD count, LPCWSTR filename)
{
	wchar_t path[MAX_PATH];
	wchar_t* fptr;

	GetFullPathName(filename, countof(path), path, &fptr);
	GetPrivateProfileString(Section, Name, defstr, buf, count, path);
}
