// Logger.h : Declaration of the CLogger

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CLogger

class ATL_NO_VTABLE CLogger :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CLogger, &CLSID_Logger>,
	public IDispatchImpl<ILogger, &IID_ILogger, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CLogger()
	{
		m_fp = NULL;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_LOGGER)


BEGIN_COM_MAP(CLogger)
	COM_INTERFACE_ENTRY(ILogger)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		if (m_fp)
			fclose(m_fp);
	}

	FILE* m_fp;
public:

	STDMETHOD(Open)(BSTR FileName);
	STDMETHOD(Close)(void);
	STDMETHOD(Log)(BSTR Msg);
};

OBJECT_ENTRY_AUTO(__uuidof(Logger), CLogger)
