// PICWriter.cpp : Implementation of CPICWriter

#include "stdafx.h"
#include "PICWriter.h"
#include "../WProtocol.h"

// CPICWriter

STDMETHODIMP CPICWriter::IncrementAddress(void)
{
	BYTE cmd6[] = { PGM_INCREMENT };
	HRESULT	r;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CPICWriter::get_pController(IWriterController** pVal)
{
	if (pVal== NULL)
		return E_POINTER;

	*pVal = m_pWriterController;
	(*pVal)->AddRef();
	return S_OK;
}

STDMETHODIMP CPICWriter::put_pController(IWriterController* newVal)
{
	if (newVal == NULL)
		return E_POINTER;

	m_pWriterController.Release();
	m_pWriterController = newVal;
	return S_OK;
}

STDMETHODIMP CPICWriter::LoadConfiguration(void)
{
	BYTE cmd6[] = { PGM_LOAD_CONFIG };
	BYTE arg14[] = { 0, 0 };
	HRESULT	r;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	r = m_pWriterController->SerialSyncWriteRaw(arg14, 16);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CPICWriter::ReadDataFromProgramMemory(LONG* pData)
{
	BYTE cmd6[] = { PGM_READ_P };
	BYTE data14[2];
	HRESULT	r;
	WORD	rdata;

	if (pData == NULL)
		return E_POINTER;

	if (m_pWriterController == NULL)
		return E_FAIL;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	r = m_pWriterController->SerialSyncReadRaw(data14, 16);
	if (FAILED(r))
		return r;
	rdata = MAKEWORD(data14[0], data14[1]);
	rdata >>= 1;
	rdata &= 0x3fff;

	*pData = (LONG)rdata;

	return S_OK;
}


STDMETHODIMP CPICWriter::ReadDataFromDataMemory(LONG* pData)
{
	BYTE cmd6[] = { PGM_READ_D };
	BYTE data14[2];
	HRESULT	r;
	WORD	rdata;

	if (pData == NULL)
		return E_POINTER;

	if (m_pWriterController == NULL)
		return E_FAIL;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	r = m_pWriterController->SerialSyncReadRaw(data14, 16);
	if (FAILED(r))
		return r;
	rdata = MAKEWORD(data14[0], data14[1]);
	rdata >>= 1;
	rdata &= 0x3fff;

	*pData = (LONG)rdata;

	return S_OK;
}

STDMETHODIMP CPICWriter::LoadDataForProgramMemory(LONG lData)
{
	return Command6Data14(PGM_LOAD_P, lData);
}

STDMETHODIMP CPICWriter::LoadDataForDataMemory(LONG lData)
{
	return Command6Data14(PGM_LOAD_D, lData);
}

STDMETHODIMP CPICWriter::BulkEraseProgramMemory(void)
{
	return Command6(PGM_BULK_ERASE_P);
}

STDMETHODIMP CPICWriter::BeginProgrammingET(void)
{
	BYTE cmd6[] = { PGM_BEGIN_P_XT };
	HRESULT	r;

	if (m_pWriterController == NULL)
		return E_FAIL;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CPICWriter::EndProgramming(void)
{
	BYTE cmd6[] = { PGM_END_P };
	HRESULT	r;

	if (m_pWriterController == NULL)
		return E_FAIL;

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CPICWriter::Command6(long cmd)
{
	BYTE cmd6[1];
	HRESULT	r;

	if (m_pWriterController == NULL)
		return E_FAIL;

	cmd6[0] = (BYTE)cmd;
	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CPICWriter::Command6Data14(long CmdByte, long DataWord)
{
	BYTE cmd6[] = { (BYTE)CmdByte };
	BYTE data14[2];
	HRESULT	r;

	if (m_pWriterController == NULL)
		return E_FAIL;

	DataWord <<= 1;
	data14[0] = (BYTE)(DataWord & 0xff);
	data14[1] = (BYTE)(DataWord >> 8);

	r = m_pWriterController->SerialSyncWriteRaw(cmd6, 6);
	if (FAILED(r))
		return r;
	r = m_pWriterController->SerialSyncWriteRaw(data14, 16);
	if (FAILED(r))
		return r;
	return S_OK;
}
