// PICWriter.h : Declaration of the CPICWriter

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CPICWriter

class ATL_NO_VTABLE CPICWriter :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CPICWriter, &CLSID_PICWriter>,
	public IDispatchImpl<IPICWriter, &IID_IPICWriter, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CPICWriter()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PICWRITER)


BEGIN_COM_MAP(CPICWriter)
	COM_INTERFACE_ENTRY(IPICWriter)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()
	DECLARE_GET_CONTROLLING_UNKNOWN()
public:
	CComPtr<IWriterController> m_pWriterController;

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		m_pWriterController.Release();
	}

public:

	STDMETHOD(IncrementAddress)(void);
	STDMETHOD(get_pController)(IWriterController** pVal);
	STDMETHOD(put_pController)(IWriterController* newVal);
	STDMETHOD(LoadConfiguration)(void);
	STDMETHOD(ReadDataFromProgramMemory)(LONG* pData);
	STDMETHOD(LoadDataForProgramMemory)(LONG DataWord);
	STDMETHOD(BulkEraseProgramMemory)(void);
	STDMETHOD(BeginProgrammingET)(void);
	STDMETHOD(EndProgramming)(void);
	STDMETHOD(Command6)(long cmd);
	STDMETHOD(ReadDataFromDataMemory)(LONG* pValue);
	STDMETHOD(LoadDataForDataMemory)(LONG lData);
	STDMETHOD(Command6Data14)(long cmd6, long data14);
};

OBJECT_ENTRY_AUTO(__uuidof(PICWriter), CPICWriter)
