// ProfileValues.h : Declaration of the CProfileValues

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"
#include "vcue_copy.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif


typedef vector<CComVariant>			ContainerType;
typedef	VARIANT						CollectionExposedType;
typedef	IProfileValues				CollectionInterface;
typedef	VARIANT						EnumeratorExposedType;
typedef	IEnumVARIANT				EnumeratorInterface;
typedef VCUE::GenericCopy<EnumeratorExposedType, ContainerType::value_type>    EnumeratorCopyType;
typedef VCUE::GenericCopy<CollectionExposedType, ContainerType::value_type>    CollectionCopyType;

typedef CComEnumOnSTL< EnumeratorInterface, &__uuidof(EnumeratorInterface), EnumeratorExposedType, EnumeratorCopyType, ContainerType >    EnumeratorType;
typedef ICollectionOnSTLImpl< CollectionInterface, ContainerType, CollectionExposedType, CollectionCopyType, EnumeratorType >    CollectionType;

// CProfileValues

class ATL_NO_VTABLE CProfileValues :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CProfileValues, &CLSID_ProfileValues>,
	public IDispatchImpl<CollectionType, &IID_IProfileValues, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CProfileValues()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PROFILEVALUES1)


BEGIN_COM_MAP(CProfileValues)
	COM_INTERFACE_ENTRY(IProfileValues)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

public:
#if 0
	STDMETHOD(get__NewEnum)(IUnknown** pVal);
	STDMETHOD(get_Item)(long Index, VARIANT* pVal);
	STDMETHOD(get_Count)(long* pVal);
#endif
	STDMETHOD(Find)(VARIANT Find, BOOL* Found) {
		HRESULT r;

		*Found = 0;

		CComVariant v(Find);
		r = v.ChangeType(VT_BSTR);
		if (FAILED(r))
			return r;

		ContainerType::iterator it;
		for (it = m_coll.begin(); it != m_coll.end(); it++) {
			CComVariant vv(*it);
			r = vv.ChangeType(VT_BSTR);
			if (FAILED(r))
				return r;
			if (wcscmp(v.bstrVal, vv.bstrVal) == 0) {
				*Found = -1;
				return S_OK;
			}
		}
		*Found = FALSE;
		return S_OK;
	}

};

OBJECT_ENTRY_AUTO(__uuidof(ProfileValues), CProfileValues)
