// Scripts.cpp : Implementation of CPWScript

#include "stdafx.h"
#include <io.h>
#include "Scripts.h"


// CPWScript


STDMETHODIMP CPWScript::AddScriptFile(BSTR FileName)
{
	CComPtr<IActiveScriptParse> pASP;
	HRESULT r;
	USES_CONVERSION;

	r = m_pAS->QueryInterface(IID_IActiveScriptParse, (void **)&pASP.p);
	if (FAILED(r))
		return r;

	FILE* fp;
	int	len;
	char*	buf;

	fp = _wfopen(FileName, L"rb");
	if (fp == NULL) {
		return Error("fopen failed");
	}
	len = _filelength(_fileno(fp));
	buf = new char[len + 1];
	if (buf == NULL) {
		fclose(fp);
		return E_OUTOFMEMORY;
	}
	fread(buf, 1, len, fp);
	fclose(fp);

	buf[len] = 0;

	EXCEPINFO ei;

	r = pASP->ParseScriptText(A2OLE(buf), NULL, NULL, NULL, 0, 0, SCRIPTTEXT_ISVISIBLE, NULL, &ei);
	delete buf;
	if (FAILED(r)) {
		AtlTrace(L"%s/%s\n", ei.bstrSource, ei.bstrDescription);
		return r;
	}

	return S_OK;
}

STDMETHODIMP CPWScript::Execute(BSTR SubName)
{
	CComPtr<IDispatch> pdisp;
	BSTR	rgszNames[1];
	DISPID	dispid[1];
	HRESULT r;
	EXCEPINFO ei;
	CLSID	typlib;

	rgszNames[0] = SubName;

	r = m_pAS->SetScriptState(SCRIPTSTATE_STARTED);
	if (FAILED(r))
		return r;

	r = CLSIDFromString(L"{9734977F-7D86-4865-9B7D-D77C67BC87ED}", &typlib);
	if (FAILED(r))
		return r;

	r = m_pAS->AddTypeLib(typlib, 1, 0, SCRIPTTYPELIB_ISCONTROL);
	if (FAILED(r))
		return r;

	r = m_pAS->GetScriptDispatch(NULL, &pdisp.p);
	if (FAILED(r))
		return r;
	r = pdisp->GetIDsOfNames(IID_NULL, rgszNames, 1, LOCALE_SYSTEM_DEFAULT, dispid);
	if (FAILED(r))
		return r;

	DISPPARAMS params;
	UINT	err;
	CComVariant	result;

	params.cArgs = 0;
	params.cNamedArgs = 0;
	params.rgdispidNamedArgs = NULL;
	params.rgvarg = NULL;

	r = pdisp->Invoke(dispid[0], IID_NULL, LOCALE_SYSTEM_DEFAULT, DISPATCH_METHOD, &params, &result, &ei, &err);
	if (FAILED(r)) {
		AtlTrace(L"%S/%S\n", ei.bstrSource, ei.bstrDescription);
		return r;
	}

	r = m_pAS->SetScriptState(SCRIPTSTATE_CLOSED);
	if (FAILED(r))
		return r;

	return S_OK;
}

STDMETHODIMP CPWScript::SetSiteWindow(long hWnd)
{
	m_hWnd = (HWND)hWnd;

	return S_OK;
}

STDMETHODIMP CPWScript::AttachEngine(IUnknown* punkActiveScript)
{
	HRESULT r;

	if (m_pAS)
		m_pAS.Release();

	r = punkActiveScript->QueryInterface(IID_IActiveScript, (void **)&m_pAS.p);
	if (FAILED(r))
		return r;

	CComPtr<IActiveScriptSite> psite;
	r = QueryInterface(IID_IActiveScriptSite, (void **)&psite.p);
	if (FAILED(r))
		return r;
	r = m_pAS->SetScriptSite(psite);
	if (FAILED(r))
		return r;

	return S_OK;
}

STDMETHODIMP CPWScript::InitScript(void)
{
	CComPtr<IActiveScriptParse> pASP;
	HRESULT r;

	r = m_pAS->QueryInterface(IID_IActiveScriptParse, (void **)&pASP.p);
	if (FAILED(r))
		return r;
	r = pASP->InitNew();
	if (FAILED(r))
		return r;

	return S_OK;
}
