OUTPUT_FORMAT("elf32-h8300")
OUTPUT_ARCH(h8300h)
ENTRY("_start")

MEMORY {
	vector(rwx)	: ORIGIN = 0x38000, LENGTH = 0x0100
	ram(rwx)	: ORIGIN = 0x38100, LENGTH = 0xff00
}

INCLUDE "3048f.x"
	
SECTIONS {
	. = 0x38000;

	.vector : {
		*(.vector)
	} > vector

	. = 0x38100;
	.text : {
		*(.text)
		_etext = .;
	} > ram
	.data : {
		*(.strings)
		*(.rodata)
		*(.data)
		*(.bss)
		_edata = .;
	} > ram

	_end = .;
	_stack = 0x48000;
}

