#include "stdafx.h"
#include "pww.h"
#include "Devices.h"

bool CDevices::load_file(LPCWSTR filename)
{
	LPWSTR buf = new wchar_t[PROFILEBUFSIZE];
	wchar_t	devsection[MAX_PATH];
	wchar_t	devname[MAX_PATH];
	LPCWSTR p;

	GetPrivateProfileString(L"Devices", NULL, NULL, buf, PROFILEBUFSIZE, filename);
	p = buf;
	while (*p != L'\0') {
		GetPrivateProfileString(L"Devices", p, NULL, devsection, sizeof(devsection), filename);
		GetPrivateProfileString(devsection, L"Name", devsection, devname, sizeof(devname), filename);
		push_back(new CDeviceEntry(filename, devsection, devname));
		p += wcslen(p) + 1;
	}
	delete buf;
	return true;
}

bool CDevices::load()
{
	LPCWSTR wild = L"*.ini";
	WIN32_FIND_DATA	wfd;
	HANDLE	hFind;
	wchar_t	dirbuf[MAX_PATH];

	GetCurrentDirectory(sizeof(dirbuf) / sizeof(wchar_t), dirbuf);

	hFind = FindFirstFile(wild, &wfd);
	while (hFind != INVALID_HANDLE_VALUE) {
		wstring fpn;
		fpn = dirbuf;
		fpn += L"\\";
		fpn += wfd.cFileName;

		load_file(fpn.c_str());
		if (!FindNextFile(hFind, &wfd)) {
			FindClose(hFind);
			hFind = INVALID_HANDLE_VALUE;
		}
	}
	return true;
}

