' PIC1628A
'
' HIGH VOLTAGE 
'		"MCLR FIRST" 
'		10V - 13.5V
' LVP(PGM)10PIN(LVPLHVPsꍇ͗vv_E)
' 1 word ƃvO~O
' BEGIN PROGRAMMING ONLY CYCLE@ "internal timed" Ȃ̂ End Programming sv
' CHIP ERASEȂ

option Explicit

const BULK_ERASE_PROGRAM_MEMORY = &h09
const BULK_ERASE_DATA_MEMORY = &h0b
const BEGIN_PROGRAMMING_ONLY = &h08

const TPROG = 4
const TDPROG = 6
const TERA = 6

dim memoryUsed

sub ProgramErase
	progress.ProgressText = "Erasing Program Memory"
	progress.NotifyText = ""

	PICWriter.LoadConfiguration
	PICWriter.LoadDataForProgramMemory &h3fff
	PICWriter.Command6 BULK_ERASE_PROGRAM_MEMORY
	util.Sleep TERA
end sub


sub ProgramProgramMemory
	dim endaddr
	dim data
	dim addr
	dim	i
	
	progress.ProgressText = "Writing Program Memory"
	progress.NotifyText = ""

	endaddr = memoryUsed
	
	PICWriter.LoadDataForProgramMemory &h01
	for addr = 0 to endaddr
		Progress.SetBar 0, endaddr - 1, addr
		
		data = Memory.ReadWord(addr)
		PICWriter.LoadDataForProgramMemory data
		PICWriter.command6 BEGIN_PROGRAMMING_ONLY
		Util.Sleep TPROG
		PICWriter.IncrementAddress
	next
end sub

sub ProgramDataMemory
	dim data
	dim addr
	dim org
	dim size
	dim rdata
	dim vaddr
	
	progress.ProgressText = "Writing Data Memory"
	progress.NotifyText = ""
	
	org = Profile.int("DataMemoryOrg")
	size = Profile.Int("DataMemorySize")
	
	PICWriter.command6 BULK_ERASE_DATA_MEMORY
	Util.Sleep TERA

	for addr = 0 to size - 1
		vaddr = addr + org
		Progress.SetBar 0, size, addr
		
		data = Memory.ReadWord(vaddr) and &hff
		PICWriter.Command6Data14 &h03, data
		
		PICWriter.command6 BEGIN_PROGRAMMING_ONLY
		Util.Sleep TDPROG
		PICWriter.IncrementAddress
	next
end sub

sub ProgramConfigMemory
	dim addr
	dim vaddr
	dim data
	dim org
	dim size

	dim px
	set px = Profile.ArrayVal("ProgramExclude", AVT_INTEGER)
	
	org = Profile.Int("ConfigMemoryOrg")
	size = Profile.Int("ConfigMemorySize")
	
	Progress.ProgressText = "Writing Config Memory"

	PICWriter.LoadDataForProgramMemory 0
	PICWriter.LoadConfiguration
	
	for addr= 0 TO size - 1
		vaddr = addr + org
		Progress.SetBar 0, size - 1, addr
		if not px.Find(vaddr) then			
			data = memory.ReadWord(vaddr)
			
			PICWriter.LoadDataForProgramMemory data
			PICWriter.command6 BEGIN_PROGRAMMING_ONLY
			Util.Sleep TPROG
		end if
		PICWriter.IncrementAddress
	next
end sub

sub InitVars
	memoryUsed = Profile.Int("ProgramMemorySize") - 1
	do while memoryUsed >= 0
		if Memory.GetFlags(memoryUsed * 2) and MF_FILLED then
			exit do
		end if
		memoryUsed = memoryUsed - 1
	loop
	memoryUsed = memoryUsed + 1
end sub

function PreProgramTest
	dim tmpmem
	
	PreProgramTest = false
	
	set tmpmem = CreateObject("NWriterObjects.HexLoader")
	tmpmem.Allocate(&h2200 * 2)
	
	Reset_PGM
	STDPIC_ReadConfigMemory tmpmem

	if not STDPIC_CheckCPCPD(tmpmem) then
		exit function
	end if
			
	if not STDPIC_CheckDeviceID(tmpmem) then
		exit function
	end if
	
	PreProgramTest = true
end function

sub Reset_PGM
	STDPIC_Reset_HVP_MCLRFIRST
end sub

sub Verify
	InitVars

	Reset_PGM
	if not STDPIC_VerifyProgramMemory() then
		STDPIC_PowerOff
		exit sub
	end if
	
	Reset_PGM
	if not STDPIC_VerifyDataMemory() then
		STDPIC_PowerOff
		exit sub
	end if
	Reset_PGM
	if not STDPIC_VerifyConfigMemory() then
		STDPIC_PowerOff
		exit sub
	end if
	STDPIC_PowerOff
	
	Progress.ProgressText = "Verify Success"
	MsgBox "Verify success"
end sub

sub Read
	InitVars

	Reset_PGM
	STDPIC_ReadProgramMemory Memory
	
	Reset_PGM
	STDPIC_ReadDataMemory Memory
	
	Reset_PGM
	STDPIC_ReadConfigMemory Memory

	STDPIC_PowerOff
end sub

sub Program
	InitVars
	
	if not PreProgramTest then
		STDPIC_PowerOff
		exit sub
	end if

	Reset_PGM
	ProgramErase
	
	Reset_PGM
	ProgramProgramMemory
	
	Reset_PGM
	ProgramDataMemory
	
	Reset_PGM
	ProgramConfigMemory
	STDPIC_PowerOff
end sub

sub ProgramDataOnly
	InitVars
	
	if not PreProgramTest then
		STDPIC_PowerOff
		exit sub
	end if
	
	Reset_PGM
	ProgramDataMemory
	STDPIC_PowerOff
end sub

sub ReadDataOnly
	InitVars
	
	Reset_PGM
	STDPIC_ReadDataMemory Memory
	STDPIC_PowerOff
end sub


sub Run
	STDPIC_Run
end sub

