// ProgressDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pww.h"
#include "ProgressDlg.h"
#include "Devices.h"
#include "ScriptThread.h"


// CProgressDlg dialog

IMPLEMENT_DYNAMIC(CProgressDlg, CDialog)

CProgressDlg::CProgressDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CProgressDlg::IDD, pParent)
{
	m_pParam = NULL;
}

CProgressDlg::~CProgressDlg()
{
	delete m_pParam;
}

void CProgressDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS, m_wndProgress);
	DDX_Control(pDX, IDC_NOTIFY_TEXT, m_wndNotifyText);
	DDX_Control(pDX, IDC_PROGRESS_TEXT, m_wndProgressText);
	DDX_Control(pDX, IDCANCEL, m_wndCancel);
}

BEGIN_MESSAGE_MAP(CProgressDlg, CDialog)
	ON_REGISTERED_MESSAGE(g_uMsgSetProgress, OnUserSetProgress)
	ON_REGISTERED_MESSAGE(g_uMsgEndThread, OnEndThread)
	ON_BN_CLICKED(IDCANCEL, &CProgressDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


// CProgressDlg message handlers

BOOL CProgressDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	try {
		CComPtr<IPWProgressNotifyInit> pInit;

		delete m_pParam;
		m_pParam = new CScriptThread;

		CreateInstance(CLSID_PWScript, IID_IPWScript, (void **)&m_pParam->m_pScriptSite.p);

		CLSID	clsid;
		HRESULT	r;
		CComPtr<IActiveScript> as;

		r = CLSIDFromProgID(L"VBScript", &clsid);
		//r = CLSIDFromProgID(L"JScript", &clsid);
		if (FAILED(r))
			return r;
		r = CoCreateInstance(clsid, NULL, CLSCTX_INPROC, IID_IActiveScript, (void **)&m_pParam->m_pEngine.p);
		if (FAILED(r))
			return r;


		m_pParam->m_hScriptSiteWnd = m_hWnd;
		m_pParam->m_hTermNotifyWnd = m_hWnd;
		m_pParam->m_uTermNotifyMsg = g_uMsgEndThread;
		m_pParam->m_pMemory = g_memory;
		m_pParam->m_pAction = m_action;

		CreateInstance(CLSID_DeviceProfile, IID_IDeviceProfile, (void **)&m_pParam->m_pProfile.p);
		E(m_pParam->m_pProfile->put_FileName((BSTR)m_action->m_pDeviceEntry->m_FileName.c_str()));
		E(m_pParam->m_pProfile->put_SectionName((BSTR)m_action->m_pDeviceEntry->m_DeviceSection.c_str()));
		E(m_action->m_pDeviceEntry->GetProfile(m_pParam->m_script, L"script"));

		E(g_notify->QueryInterface(IID_IPWProgressNotifyInit, (void **)&pInit.p));
		pInit->SetNotifyMethod((wireHWND)m_hWnd, g_uMsgSetProgress, 0);

		E(m_pParam->CreateObjects());

		DWORD id;
		HANDLE	hThread;

		hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ScriptThreadMain, (LPVOID)m_pParam, 0, &id);
		//ScriptThreadMain(m_pParam);

		return TRUE;  // return TRUE unless you set the focus to a control
	}
	catch (HRESULTEXCEPTION& ex) {
		delete m_pParam;
		m_pParam = NULL;

		CString s;
		s.Format(L"Error %08x", ex.hr);
		AfxMessageBox(s);
		EndDialog(ex.hr);
	}
	return TRUE;
}

LRESULT CProgressDlg::OnUserSetProgress(WPARAM wParam, LPARAM lParam)
{
	PROGRESSNOTIFYHEADER* ph;
	BYTE* p;

	HGLOBAL	hMem = (HGLOBAL)lParam;
	p = (BYTE*)::GlobalLock(hMem);
	ph = (PROGRESSNOTIFYHEADER*)p;
	if (ph == NULL)
		return 0;
	if (ph->flags & PNF_MINMAX) {
		m_wndProgress.SetRange32(ph->nProgressMin, ph->nProgressMax);
	}
	if (ph->flags & PNF_BAR) {
		m_wndProgress.SetPos(ph->nProgressBar);
	}
	if (ph->flags & PNF_PTEXT) {
		m_wndProgressText.SetWindowText((LPCWSTR)(p + ph->nProgressTextOffset));
	}
	if (ph->flags & PNF_NTEXT) {
		m_wndNotifyText.SetWindowText((LPCWSTR)(p + ph->nNotifyTextOffset));
	}
	UpdateWindow();
	GlobalUnlock(hMem);
	GlobalFree(hMem);
	return 0;
}

LRESULT CProgressDlg::OnEndThread(WPARAM wParam, LPARAM lParam)
{
	wchar_t	buf[100];

	if (lParam) {
		_snwprintf(buf, sizeof(buf) / 2, L"Thread terminated with an error %08x", lParam);
		AfxMessageBox(buf);
	}
	delete m_pParam;
	m_pParam = NULL;
	EndDialog(0);
	return 0;
}

void CProgressDlg::OnBnClickedCancel()
{
	m_pParam->Cancel();
}

HRESULT CScriptThread::Cancel(void)
{
	EXCEPINFO ei;
	HRESULT r;

	memset(&ei, 0, sizeof(ei));
	ei.bstrSource = SysAllocString(L"NPICWriter");
	ei.scode = E_FAIL;

	r = m_pEngine->InterruptScriptThread(SCRIPTTHREADID_ALL, &ei, SCRIPTINTERRUPT_RAISEEXCEPTION);

	return r;
}
