// VoltageDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pww.h"
#include "VoltageDlg.h"
#include "CalibrationDlg.h"


// CVoltageDlg dialog

IMPLEMENT_DYNAMIC(CVoltageDlg, CDialog)

CVoltageDlg::CVoltageDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVoltageDlg::IDD, pParent)
{

}

CVoltageDlg::~CVoltageDlg()
{
}

void CVoltageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DIGIT, m_wndDigit);
	DDX_Control(pDX, IDC_RAW, m_wndRaw);
}


BEGIN_MESSAGE_MAP(CVoltageDlg, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_RAW, &CVoltageDlg::OnBnClickedRaw)
	ON_BN_CLICKED(IDC_CALIBRATION, &CVoltageDlg::OnBnClickedCalibration)
END_MESSAGE_MAP()

#define TIMER_DURATION 1000
// CVoltageDlg message handlers

BOOL CVoltageDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_vcalc.load();

	CFont font;
	LOGFONT lf;

	memset(&lf, 0, sizeof(lf));
	lf.lfHeight = 30;
	m_font.CreateFontIndirectW(&lf);
	m_wndDigit.SetFont(&m_font);

	CString	dcbstr;

	dcbstr = AfxGetApp()->GetProfileString(szWriter, szPort, szPortDefault);

	try {
		CreateInstance(CLSID_ComPort, IID_IComPort, (void **)&m_pComPort.p);
		CreateInstance(CLSID_WriterController, IID_IWriterController, (void **)&m_pController.p);

		E(m_pComPort->Open((BSTR)(LPCWSTR)dcbstr));
		E(m_pController->AttachPort(m_pComPort));
		SetTimer(1, TIMER_DURATION, NULL);
	}
	catch(HRESULTEXCEPTION&) {
		EndDialog(-1);
	}
	return TRUE;
}

void CVoltageDlg::OnTimer(UINT_PTR nIDEvent)
{
	LONG n;
	HRESULT r;
	wchar_t	buf[16];

	r = m_pController->AnalogRead(0, &n);
	if (FAILED(r)) {
		KillTimer(1);
		AfxMessageBox(L"AnalogRead function failed");
		EndDialog(-1);
	}

	double v;

	v = m_vcalc.Convert(n);
	if (m_wndRaw.GetCheck())
		_snwprintf(buf, sizeof(buf)/ sizeof(wchar_t), L"%d", n);
	else
		_snwprintf(buf, sizeof(buf)/ sizeof(wchar_t), L"%.1fV", v);
	m_wndDigit.SetWindowText(buf);
	SetTimer(1, TIMER_DURATION, NULL);
	CDialog::OnTimer(nIDEvent);
}

void CVoltageDlg::OnBnClickedRaw()
{
	// TODO: Add your control notification handler code here
}

void CVoltageDlg::OnBnClickedCalibration()
{
	CCalibrationDlg	dialog(this);

	dialog.DoModal();
	m_vcalc.load();
}
