// pww.h : main header file for the pww application
//
#pragma once

#ifndef __AFXWIN_H__
	#error "include 'stdafx.h' before including this file for PCH"
#endif

#include "resource.h"       // main symbols
#pragma warning(disable: 4192)
#import "../NWriterObjects/debug/NWriterObjects.dll" raw_interfaces_only, raw_native_types, no_namespace, named_guids 

// CpwwApp:
// See pww.cpp for the implementation of this class
//

extern LPCWSTR szWriter;

extern LPCWSTR szPort;
extern LPCWSTR szPortDefault;

extern LPCWSTR szVoltageCalibration;


extern CComPtr<ILogger> g_logger;
extern CComPtr<IPWProgressNotify> g_notify;
extern CComPtr<IPWScript>	g_script;

#if 0
extern CComPtr<IComPort> pComPort;
extern HWND	g_hThreadControllingWnd;
extern CComPtr<IWriterController> pController;
#endif

extern void CreateInstance(REFCLSID clsid, REFIID riid, LPVOID* ppv);

class CMenuAction;

extern wstring	curdir;

extern UINT g_uMsgSetProgress;
extern UINT g_uMsgEndThread;
extern CComPtr<IMemory> g_memory;

class HRESULTEXCEPTION {
public:
	HRESULT	hr;
	HRESULTEXCEPTION (HRESULT r) : hr(r) {
	}
};

extern void _ThrowIfFail(HRESULT r);


#define ThrowIfFail(r)	_ThrowIfFail(r)
#define E(r)	_ThrowIfFail(r)
//#define ThrowIfFail(r)	ASSERT(!FAILED(r))

class CDeviceEntry;

class CMenuAction;

class CMenuItem {
public:
	virtual bool isSeparator() = 0;
};

class CMenuSeparator : public CMenuItem {
public:
	bool	isSeparator()	{ return true; }
};

class CMenuAction : public CMenuItem {
public:
	CMenuAction(CDeviceEntry* pent, LPCWSTR m, LPCWSTR e) : m_pDeviceEntry(pent), m_strMenuText(m), m_strSubEntry(e) {
	}
	CDeviceEntry* m_pDeviceEntry;
	wstring	m_strMenuText;
	wstring	m_strSubEntry;
	bool	isSeparator() { return false; }
};


class CpwwApp : public CWinApp
{
public:
	CpwwApp();


// Overrides
public:
	virtual BOOL InitInstance();

// Implementation

public:
	afx_msg void OnAppAbout();
	DECLARE_MESSAGE_MAP()
	virtual int ExitInstance();
};

extern CpwwApp theApp;