// H8DeviceInitializer.cpp : Implementation of CH8DeviceInitializer

#include "stdafx.h"
#include "H8DeviceInitializer.h"
#include "../WProtocol.h"


// CH8DeviceInitializer

HRESULT WaitSequence(IComPort* pPort, const char* tpl) {
	const char* p;
	short c;
	HRESULT r;

	p = tpl;
	while (*p) {
		r = pPort->ReadChar(&c);
		if (FAILED(r))
			return r;
		if (c == EOF)
			return S_FALSE;
		if (c != *p) {
			p = tpl;
			if (c != *p)
				continue;
		}
		p++;
	}
	return S_OK;
}

HRESULT WaitPrompt(IComPort* pPort) {
	return WaitSequence(pPort, "\r\n: ");
}


STDMETHODIMP CH8DeviceInitializer::Initialize(IComPort* pPort, BSTR OptionString, VARIANT OptionValue)
{
	HRESULT r;
	short c;

	m_pProgressNotify->put_ProgressText(L"Querying H8 program's running state");
	m_pProgressNotify->put_NotifyText(L"Sending CR for querying in monitor");
	//m_pProgressNotify->Update(PNF_NTEXT | PNF_PTEXT);

	r = pPort->WriteChar('\r');
	if (FAILED(r))
		return r;

	m_pProgressNotify->put_NotifyText(L"Waiting response");
	//m_pProgressNotify->Update(PNF_NTEXT | PNF_PTEXT);

	r = pPort->PeekChar(&c);
	if (FAILED(r))
		return r;
	if (c == NAK) {
		r = pPort->ReadChar(&c);
		m_pProgressNotify->put_NotifyText(L"Writer Program is running on H8");
		return S_OK;			// ɃAvP[VĂ
	}

	m_pProgressNotify->put_NotifyText(L"Waiting for H8 monitor prompt");

	r = WaitPrompt(pPort);
	if (FAILED(r))
		return r;

	m_pProgressNotify->put_NotifyText(L"Send L command");

	r = pPort->WriteString(L"L\r");
	if (FAILED(r))
		return r;

	m_pProgressNotify->put_NotifyText(L"Waiting CR LF");

	r = WaitSequence(pPort, "\r\n");
	if (FAILED(r))
		return r;

	r = SendFile(pPort, OptionString);
	if (FAILED(r))
		return r;

	r = WaitPrompt(pPort);
	if (FAILED(r))
		return r;

	r = pPort->WriteString(L"G\r");
	if (FAILED(r))
		return r;

	r = WaitSequence(pPort, "\r\n");
	if (FAILED(r))
		return r;

	return S_OK;
}

HRESULT CH8DeviceInitializer::SendFile(IComPort* pPort, BSTR strFileName)
{
	FILE* fp;
	char	buf[1024];
	char*	p;
	HRESULT r;

	fp = _wfopen(strFileName, L"r");
	if (fp == NULL) {
		return Error("H8 Program file could not be opened");
	}

	long len;
	long bar;

	len = (long)_filelength(_fileno(fp));
	bar = 0;

	m_pProgressNotify->put_NotifyText(L"Sending SREC");
	m_pProgressNotify->SetBar(0, len, bar);


	while (fgets(buf, sizeof(buf), fp) != NULL) {
		bar += (long)strlen(buf);
		p = strchr(buf, '\n');
		if (p) {
			*p = '\r';
			bar++;
		}
		r = pPort->Write((BYTE *)buf, (DWORD)strlen(buf), NULL);
		if (FAILED(r))
			return r;
		m_pProgressNotify->SetBar(0, len, bar);
	}
	return S_OK;
}
