// H8DeviceInitializer.h : Declaration of the CH8DeviceInitializer

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CH8DeviceInitializer

class ATL_NO_VTABLE CH8DeviceInitializer :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CH8DeviceInitializer, &CLSID_H8DeviceInitializer>,
	public IDispatchImpl<IDeviceInitializer, &IID_IDeviceInitializer, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public IDispatchImpl<IPWSetProgressNotify, &__uuidof(IPWSetProgressNotify), &LIBID_NWriterObjectsLib, /* wMajor = */ 1, /* wMinor = */ 0>
{
public:
	CH8DeviceInitializer()
	{
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_H8DEVICEINITIALIZER)


	BEGIN_COM_MAP(CH8DeviceInitializer)
		COM_INTERFACE_ENTRY(IDeviceInitializer)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(IPWSetProgressNotify)
	END_COM_MAP()


	DECLARE_PROTECT_FINAL_CONSTRUCT()

public:
	CComPtr<IPWProgressNotify> m_pProgressNotify;

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		m_pProgressNotify.Release();
	}

public:

	STDMETHOD(Initialize)(IComPort* pPort, BSTR OptionString, VARIANT OptionValue);
	HRESULT SendFile(IComPort* pPort, BSTR strFileName);



	// IPWSetProgressNotify Methods
public:
	STDMETHOD(SetProgressNotify)(IUnknown * punkProgressNotify)
	{
		HRESULT r;

		if (m_pProgressNotify)
			m_pProgressNotify.Release();
		r = punkProgressNotify->QueryInterface(IID_IPWProgressNotify, (void **)&m_pProgressNotify.p);
		if (FAILED(r))
			return r;
		return S_OK;
	}
};

OBJECT_ENTRY_AUTO(__uuidof(H8DeviceInitializer), CH8DeviceInitializer)
