// HexLoader.cpp : Implementation of CHexLoader

#include "stdafx.h"
#include "HexLoader.h"


// CHexLoader
STDMETHODIMP CHexLoader::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IComPort
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}


HRESULT CHexLoader::Allocate(ULONG bytes)
{
	delete m_memory;
	delete m_flags;
	m_memory = NULL;
	m_flags = NULL;

	m_memory_size = bytes;
	m_memory = new BYTE[m_memory_size];
	m_flags = new BYTE[m_memory_size];
	if (m_memory == NULL)
		return E_OUTOFMEMORY;
	memset(m_memory, 0xff, bytes);
	memset(m_flags, 0x00, bytes);
	return S_OK;
}

HRESULT CHexLoader::ReadByte(ULONG address, BYTE * rval)
{
	if (rval == NULL)
		return E_POINTER;
	if (address >= m_memory_size)
		return E_INVALIDARG;
	*rval = m_memory[address] & (BYTE)m_mask;
	return S_OK;
}

HRESULT CHexLoader::WriteByte(ULONG address, BYTE val)
{
	if (address >= m_memory_size)
		return E_INVALIDARG;
	m_memory[address] = val & (BYTE)m_mask;
	m_flags[address] = MF_FILLED;
	return S_OK;
}

static DWORD readbin(BYTE** ptr, int length)
{
	DWORD rval = 0;
	while (length-- > 0) {
		rval <<= 8;
		rval |= **ptr;
		(*ptr)++;
	}
	return rval;
}


HRESULT CHexLoader::Load(BSTR FileName, LONG FileType)
{
	FILE* fp;
	char	buf[600];
	BYTE	bindata[300];

	InitNew();
	if ((fp = _wfopen(FileName, L"r")) == NULL)
		return Error("Could not open file");
	while (fgets(buf, sizeof(buf), fp) != NULL) {
		char* p;
		size_t	len;
		int		i;

		if ((p = strchr(buf, '\n')) != NULL)
			*p = '\0';
		
		p = buf;
		if (*p++ != ':') {
			continue;
		}

		len = strlen(p);
		if (len & 1) {
			continue;
		}

		int bytes = (int)(len / 2);

		char	hex[3];
		BYTE	lsum = 0;

		hex[2] = 0;
		for (i = 0; i < bytes; i++) {
			hex[0] = *p++;
			hex[1] = *p++;
			lsum += bindata[i] = (BYTE)strtoul(hex, NULL, 16);
		}
		if (lsum != 0) {
			continue;
		}
		BYTE* binptr = bindata;
		int count = readbin(&binptr, 1);
		if (count != bytes - 5) {
			continue;
		}
		DWORD address = (WORD)readbin(&binptr, 2);
		WORD rectype = (WORD)readbin(&binptr, 1);
		BYTE* dataptr = binptr;

		switch (rectype) {
		case 0x00:
			if (address + count > m_memory_size) {
				return Error("Address exceeds memory area");
			}
			memcpy(m_memory + address, dataptr, count);
			for (i = 0; i < count; i++)
				m_flags[address + i] |= MF_FILLED;
			break;
		}
	}
	return S_OK;
}


STDMETHODIMP CHexLoader::GetFlags(ULONG address, BYTE* rval)
{
	if (rval == NULL)
		return E_POINTER;
	if (address >= m_memory_size)
		return E_INVALIDARG;
	*rval = m_flags[address];
	return S_OK;
}

STDMETHODIMP CHexLoader::GetPointer(BYTE** ppBuffer, BYTE** ppFlags, ULONG* pMemorySize)
{
	*ppBuffer = m_memory;
	*ppFlags = m_flags;
	*pMemorySize = m_memory_size;
	return S_OK;
}

STDMETHODIMP CHexLoader::WriteWord(ULONG waddress, long wdata)
{
	HRESULT r;

	waddress <<= 1;

	wdata &= (WORD)m_mask;
	switch (m_endian) {
	case endianLittle:
		r = WriteByte(waddress, LOBYTE(wdata));
		if (FAILED(r))
			return r;
		r = WriteByte(waddress + 1, HIBYTE(wdata));
		if (FAILED(r))
			return r;
		break;
	case endianBig:
		r = WriteByte(waddress + 1, LOBYTE(wdata));
		if (FAILED(r))
			return r;
		r = WriteByte(waddress, HIBYTE(wdata));
		if (FAILED(r))
			return r;
		break;
	default:
		return E_UNEXPECTED;
	}
	return S_OK;
}

STDMETHODIMP CHexLoader::ReadWord(ULONG waddress, long* wdata)
{
	BYTE	l, h;
	HRESULT r;

	waddress <<= 1;

	switch (m_endian) {
	case endianLittle:
		r = ReadByte(waddress, &l);
		if (FAILED(r))
			return r;
		r = ReadByte(waddress + 1, &h);
		if (FAILED(r))
			return r;
		break;
	case endianBig:
		r = ReadByte(waddress + 1, &l);
		if (FAILED(r))
			return r;
		r = ReadByte(waddress, &h);
		if (FAILED(r))
			return r;
		break;
	default:
		return E_UNEXPECTED;
	}
	*wdata = MAKEWORD(l, h) & (WORD)m_mask;
	return S_OK;
}

STDMETHODIMP CHexLoader::get_Endian(MEMORYENDIAN* pVal)
{
	*pVal = m_endian;
	return S_OK;
}

STDMETHODIMP CHexLoader::put_Endian(MEMORYENDIAN newVal)
{
	m_endian = newVal;
	return S_OK;
}

STDMETHODIMP CHexLoader::get_Mask(long* pVal)
{
	*pVal = m_mask;
	return S_OK;
}

STDMETHODIMP CHexLoader::put_Mask(long newVal)
{
	m_mask = newVal;
	return S_OK;
}

STDMETHODIMP CHexLoader::InitNew(void)
{
	memset(m_memory, 0xff, m_memory_size);
	memset(m_flags, 0x00, m_memory_size);
	return S_OK;
}
