// Logger.cpp : Implementation of CLogger

#include "stdafx.h"
#include "Logger.h"


// CLogger


STDMETHODIMP CLogger::Open(BSTR FileName)
{
	m_fp = _wfopen(FileName, L"w");
	if (m_fp == NULL) {
		return Error("fopen failed");
	}
	return S_OK;
}

STDMETHODIMP CLogger::Close(void)
{
 	fclose(m_fp);
	m_fp = NULL;
	return S_OK;
}

STDMETHODIMP CLogger::Log(BSTR Msg)
{
	USES_CONVERSION;

	if (m_fp == NULL)
		return E_UNEXPECTED;
	fputs(OLE2A(Msg), m_fp);
	return S_OK;
}
