// ProgressNotify.cpp : Implementation of CProgressNotify

#include "stdafx.h"
#include "ProgressNotify.h"


// CProgressNotify

STDMETHODIMP CProgressNotify::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IProgressNotify
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CProgressNotify::put_NotifyText(BSTR newVal)
{
	m_NotifyText = newVal;
	Update((UINT)-1);
	return S_OK;
}

STDMETHODIMP CProgressNotify::put_ProgressText(BSTR newVal)
{
	m_ProgressText = newVal;
	Update((UINT)-1);
	return S_OK;
}

STDMETHODIMP CProgressNotify::put_BarMin(UINT newVal)
{
	m_BarMin = newVal;
	Update((UINT)-1);
	return S_OK;
}

STDMETHODIMP CProgressNotify::put_BarMax(UINT newVal)
{
	m_BarMax = newVal;
	Update((UINT)-1);
	return S_OK;
}

STDMETHODIMP CProgressNotify::put_BarValue(UINT newVal)
{
	m_BarValue = newVal;
	Update((UINT)-1);
	return S_OK;
}

STDMETHODIMP CProgressNotify::Update(UINT Flags)
{
	PROGRESSNOTIFYHEADER* pheader;
	UINT bufsize;
	UINT ntextoff = 0;
	UINT ptextoff = 0;
	HGLOBAL hMem;
	BYTE*	pbuf;

	if (m_hWnd == NULL || m_uMessage == 0)
		return E_UNEXPECTED;

	bufsize = sizeof(PROGRESSNOTIFYHEADER);
	if (Flags & PNF_NTEXT) {
		ntextoff = bufsize;
		bufsize += (m_NotifyText.Length() + 1) * 2;
	}
	if (Flags & PNF_PTEXT) {
		ptextoff = bufsize;
		bufsize += (m_ProgressText.Length() + 1) * 2;
	}
	hMem = GlobalAlloc(GMEM_ZEROINIT | GMEM_MOVEABLE, bufsize);
//	hMem = GlobalAlloc(GMEM_ZEROINIT | GMEM_MOVEABLE, 1024);
	if (hMem == NULL) {
		AtlTrace("Win32 Error %08x", GetLastError());
		return E_OUTOFMEMORY;
	}
	pbuf = (LPBYTE)GlobalLock(hMem);
	if (pbuf == NULL) {
		return E_OUTOFMEMORY;
	}
	pheader = (PROGRESSNOTIFYHEADER *)pbuf;
	pheader->cbHeader = sizeof(PROGRESSNOTIFYHEADER);
	pheader->flags = Flags;
	pheader->nNotifyTextOffset = ntextoff;
	pheader->nProgressTextOffset = ptextoff;
	pheader->nProgressMax = m_BarMax;
	pheader->nProgressMin = m_BarMin;
	pheader->nProgressBar = m_BarValue;
	if (Flags & PNF_NTEXT) {
		wcscpy((LPWSTR)(pbuf + ntextoff), m_NotifyText);
	}
	if (Flags & PNF_PTEXT) {
		wcscpy((LPWSTR)(pbuf + ptextoff), m_ProgressText);
	}
	GlobalUnlock(hMem);

	if (!::PostMessage(m_hWnd, m_uMessage, NULL, (LPARAM)hMem)) {
		GlobalFree(hMem);
	}
	return S_OK;
}

STDMETHODIMP CProgressNotify::SetBar(LONG Min, LONG Max, LONG Value)
{
	m_BarMin = Min;
	m_BarMax = Max;
	m_BarValue = Value;
	Update((UINT)-1);
	return S_OK;
}
