// ProgressNotify.h : Declaration of the CProgressNotify

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CProgressNotify

class ATL_NO_VTABLE CProgressNotify :
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CProgressNotify, &CLSID_ProgressNotify>,
	public ISupportErrorInfo,
	public IDispatchImpl<IPWProgressNotify, &IID_IPWProgressNotify, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public IDispatchImpl<IPWProgressNotifyInit, &__uuidof(IPWProgressNotifyInit), &LIBID_NWriterObjectsLib, /* wMajor = */ 1, /* wMinor = */ 0>
{
public:
	CProgressNotify()
	{
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_PROGRESSNOTIFY)


	BEGIN_COM_MAP(CProgressNotify)
		COM_INTERFACE_ENTRY(IPWProgressNotify)
		COM_INTERFACE_ENTRY(IDispatch)
		COM_INTERFACE_ENTRY(ISupportErrorInfo)
		COM_INTERFACE_ENTRY(IPWProgressNotifyInit)
	END_COM_MAP()

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		m_BarMin = 0;
		m_BarMax = 100;
		m_BarValue = 0;
		m_NotifyText = L"";
		m_ProgressText = L"";
		return S_OK;
	}

	void FinalRelease()
	{
	}

public:

	STDMETHOD(put_NotifyText)(BSTR newVal);
	STDMETHOD(put_ProgressText)(BSTR newVal);
	STDMETHOD(put_BarMin)(UINT newVal);
	STDMETHOD(put_BarMax)(UINT newVal);
	STDMETHOD(put_BarValue)(UINT newVal);
	STDMETHOD(Update)(UINT Flags);

	HWND		m_hWnd;
	UINT		m_uMessage;

	CComBSTR	m_NotifyText;
	CComBSTR	m_ProgressText;
	UINT		m_BarMin;
	UINT		m_BarMax;
	UINT		m_BarValue;

	// IPWProgressNotifyInit Methods
public:
	STDMETHOD(SetNotifyMethod)(HWND hWnd, UINT uMessage, UINT Flags)
	{
		m_hWnd = hWnd;
		m_uMessage = uMessage;
		return S_OK;
	}
	STDMETHOD(SetBar)(LONG Min, LONG Max, LONG Value);
};

OBJECT_ENTRY_AUTO(__uuidof(ProgressNotify), CProgressNotify)
