// Sequencer.h : Declaration of the CSequencer

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CSequencer

class ATL_NO_VTABLE CSequencer :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CSequencer, &CLSID_Sequencer>,
	public IDispatchImpl<ISequencer, &IID_ISequencer, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CSequencer()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SEQUENCER)


BEGIN_COM_MAP(CSequencer)
	COM_INTERFACE_ENTRY(ISequencer)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		m_pMemory.Release();
		m_pWriter.Release();
	}

	CComPtr<IMemory>	m_pMemory;
	CComPtr<IPICWriter>	m_pWriter;
public:

	STDMETHOD(SetMemory)(IMemory* pMemory);
	STDMETHOD(SetWriter)(IPICWriter* pWriter);
	STDMETHOD(Run)(BSTR Name, BSTR OptionString, LONG OptionValue, VARIANT* OptionVariant);
	STDMETHOD(GetIDispatch)(IDispatch** ppDispatch);
};

OBJECT_ENTRY_AUTO(__uuidof(Sequencer), CSequencer)
