// WriterController.cpp : Implementation of CWriterController

#include "stdafx.h"
#include "WriterController.h"
#include "../WProtocol.h"


// CWriterController

STDMETHODIMP CWriterController::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IWriterController
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CWriterController::AttachPort(IComPort* PortObject)
{
	m_PortObject = PortObject;
	return S_OK;
}

STDMETHODIMP CWriterController::SerialSyncWriteRaw( BYTE * pDataBuf, SHORT nBits)
{
	BYTE	buf[256];
	BYTE*	p = buf;
	BYTE	sum;
	int		bytecount;
	int		i;
	HRESULT	r;

	bytecount = (nBits + 7) / 8;

	logprintf("W%02d ", nBits);
	sum = 0;
	sum -= *p++ = WP_SERIALSYNCWRITE;
	sum -= *p++ = 0x80 | nBits;

	for (i = 0; i < bytecount; i++) {
		sum -= *p++ = pDataBuf[i];
		logprintf(" %02x", pDataBuf[i]);
	}
#ifdef USESUMETX
	*p++ = sum;
	*p++ = ETX;
#endif
	logprintf("\n");
	r = PortWrite(buf, p - buf);
	if (FAILED(r)) {
		return r;
	}

	r = WaitAck();
	if (FAILED(r))
		return r;
	return r;
}

STDMETHODIMP CWriterController::SerialSyncWrite(IUnknown* punkDataBuf, SHORT nBits)
{
	HRESULT r;
	CComQIPtr<IBufferPtr> pBufferPtr;
	BYTE*	pBuffer;
	LONG	nBufferSize;

	pBufferPtr = punkDataBuf;
	r = pBufferPtr->GetPointer(&pBuffer, &nBufferSize);
	if (FAILED(r))
		return r;
	r = SerialSyncWriteRaw(pBuffer, nBits);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CWriterController::SerialSyncReadRaw( BYTE * pResult,  SHORT nBits)
{
	BYTE	sum;
	int		bytecount;
	int		i;
	HRESULT	r;
	byte	buf[2];
	SHORT	c;

	logprintf("R%02d ", nBits);
	bytecount = (nBits + 7) / 8;

	BYTE* p = buf;

	*p++ = WP_SERIALSYNCREAD;
	*p++ = 0x80 | nBits;
	
	r = PortWrite(buf, p - buf);
	if (FAILED(r)) {
		return r;
	}

	r = WaitAck();
	if (r != S_OK) {	// NAKMS_FALSEԂ
		return r;
	}

	p = pResult;
	sum = 0;
	for (i = 0; i < bytecount; i++) {
		r = m_PortObject->ReadChar(&c);
		if (FAILED(r))
			return r;
		sum += *p++ = (BYTE)c;
		logprintf(" %02x", c & 0xff);
	}
	logprintf("\n");
#ifdef USESUMETX
	r = m_PortObject->ReadChar(&c);
	if (FAILED(r))
		return r;

	sum += c;

	r = m_PortObject->ReadChar(&c);
	if (FAILED(r))
		return r;

	BYTE etx = (BYTE)c;

	if (sum != 0) {
		return Error("Message checksum error");
	}
	if (etx != ETX) {
		return Error("ETX was not found");
	}
#endif
	return S_OK;
}

STDMETHODIMP CWriterController::SerialSyncRead(IUnknown* punkDataBuf, SHORT nBits)
{
	HRESULT r;
	CComQIPtr<IBufferPtr> pBufferPtr;
	BYTE*	pBuffer;
	LONG	nBufferSize;

	pBufferPtr = punkDataBuf;
	r = pBufferPtr->GetPointer(&pBuffer, &nBufferSize);
	if (FAILED(r))
		return r;
	r = SerialSyncReadRaw(pBuffer, nBits);
	if (FAILED(r))
		return FALSE;
	return S_OK;
}

STDMETHODIMP CWriterController::PortControl(BYTE bIO)
{
	BYTE	buf[2];
	BYTE*	p = buf;
	HRESULT	r;

	if (bIO & 0x80) {
		return Error("MSB is not available for Port Control");
	}
	*p++ = WP_PORTCONTROL;
	*p++ = 0x80 | bIO;
	
	r = PortWrite(buf, p - buf);
	if (FAILED(r))
		return r;

	r = WaitAck();
	if (FAILED(r)) {
		return r;
	}
	return r;
}

HRESULT CWriterController::LineControlRaw(BYTE * pSequence,  SHORT nBits)
{
	BYTE	buf[140];
	BYTE*	p = buf;
	BYTE	sum = 0;
	int		i;
	HRESULT	r;

	sum -= *p++ = WP_LINECONTROL;
	sum -= *p++ = nBits | 0x80;

	for (i = 0; i < nBits; i++) {
		if (pSequence[i] & 0x80) {
			return Error("MSB is not available for Line Control");
		}
		sum -= *p++ = pSequence[i];
	}
#ifdef USESUMETX
	*p++ = sum;
	*p++ = ETX;
#endif

	r = PortWrite(buf, p - buf);
	if (FAILED(r))
		return r;

	r = WaitAck();
	if (FAILED(r))
		return r;

	return r;
}

STDMETHODIMP CWriterController::LineControl(IUnknown* punkSequence, SHORT nBits)
{
	HRESULT r;
	CComQIPtr<IBufferPtr> pBufferPtr;
	BYTE*	pBuffer;
	LONG	nBufferSize;

	pBufferPtr = punkSequence;
	r = pBufferPtr->GetPointer(&pBuffer, &nBufferSize);
	if (FAILED(r))
		return r;
	r = LineControlRaw(pBuffer, nBits);
	if (FAILED(r)) {
		return r;
	}
	return r;
}

HRESULT CWriterController::WaitAck(void)
{
	short c;
	HRESULT r;
more:
	r = m_PortObject->ReadChar(&c);
	if (FAILED(r))
		return r;
	if (c == ACK) {
		return S_OK;
	}
	if (c == STX) {
		AtlTrace("STX[");
		while (true) {
			r = m_PortObject->ReadChar(&c);
			if (FAILED(r))
				return r;
			if (c == ETX)
				break;
			AtlTrace("%c", c);
		}
		AtlTrace("]ETX\n");
		goto more;
	}
	if (c == NAK) {
		AtlTrace("NAK received\n");
		return S_FALSE;
	}

	AtlTrace("Unexpected character %02x while waiting ACK/NAK\n", c);
	do {
		AtlTrace("Unexpected character %02x while waiting ACK/NAK\n", c);
		r = m_PortObject->ReadChar(&c);
		if (FAILED(r))
			return r;
	} while (true);
	return E_FAIL;
}

HRESULT CWriterController::PortWrite(const void * buf, size_t size)
{
	HRESULT r;

	r = m_PortObject->Write((BYTE *)buf, (DWORD)size, NULL);
	if (FAILED(r))
		return r;

	return S_OK;
}


STDMETHODIMP CWriterController::SetSyncWait(LONG nWait)
{
	HRESULT r;

	if (nWait < 0 || nWait > 127)
		return E_INVALIDARG;

	r = m_PortObject->WriteChar(WP_SETSYNCWAIT);
	if (FAILED(r))
		return r;

	r = m_PortObject->WriteChar((short)(0x80 | nWait));
	if (FAILED(r))
		return r;

	r = WaitAck();
	if (FAILED(r))
		return r;
	return r;
}

STDMETHODIMP CWriterController::SetLineWait(LONG nWait)
{
	HRESULT r;

	if (nWait < 0 || nWait > 127)
		return E_INVALIDARG;

	r = m_PortObject->WriteChar(WP_SETLINEWAIT);
	if (FAILED(r))
		return r;

	r = m_PortObject->WriteChar((short)(0x80 | nWait));
	if (FAILED(r))
		return r;

	r = WaitAck();
	if (FAILED(r))
		return r;
	return r;
}

STDMETHODIMP CWriterController::Info(IUnknown* punkInfo)
{
	HRESULT r;
	CComQIPtr<IBufferPtr> pBufferPtr;
	BYTE*	pBuffer;
	LONG	nBufferSize;

	pBufferPtr = punkInfo;
	r = pBufferPtr->GetPointer(&pBuffer, &nBufferSize);
	if (FAILED(r))
		return r;
	r = InfoRaw(pBuffer);
	if (FAILED(r))
		return r;
	return S_OK;
}

STDMETHODIMP CWriterController::InfoRaw(BYTE* InfoBytes)
{
	BYTE	sum;
	int		i;
	HRESULT	r;
	byte	buf[2];
	SHORT	c;

	BYTE* p = buf;

	*p++ = WP_INFO;
	*p++ = 0x84;
	
	r = PortWrite(buf, p - buf);
	if (FAILED(r)) {
		return r;
	}

	r = WaitAck();
	if (r != S_OK) {	// NAKMS_FALSEԂ
		return r;
	}

	p = InfoBytes;
	sum = 0;
	for (i = 0; i < 4; i++) {
		r = m_PortObject->ReadChar(&c);
		if (FAILED(r))
			return r;
		sum += *p++ = (BYTE)c;
	}
#ifdef USESUMETX
	r = m_PortObject->ReadChar(&c);
	if (FAILED(r))
		return r;
	sum += c;

	r = m_PortObject->ReadChar(&c);
	if (FAILED(r))
		return r;

	BYTE etx = (BYTE)c;

	if (sum != 0) {
		return Error("Message checksum error");
	}
	if (etx != ETX) {
		return Error("ETX was not found");
	}
#endif
	return S_OK;
}

STDMETHODIMP CWriterController::AnalogRead(LONG nPort, LONG* ADValue)
{
	BYTE	buf[2];
	BYTE*	p = buf;
	HRESULT	r;
	short	l, h;

	*p++ = WP_HVREAD;
	*p++ = (BYTE)nPort | 0x80;
	r = PortWrite(buf, p - buf);
	if (FAILED(r))
		return r;
	r = WaitAck();
	if (r == S_FALSE)
		return E_FAIL;

	r = m_PortObject->ReadChar(&l);
	if (FAILED(r))
		return r;
	r = m_PortObject->ReadChar(&h);
	if (FAILED(r))
		return r;

	*ADValue = MAKEWORD(l, h);
	return S_OK;
}
