	radix	dec
	errorlevel	-302

	include "p16f88.inc"
	__config	_CONFIG1, _INTRC_IO & _WDT_OFF
	__config	_CONFIG2, _IESO_ON & _FCMEN_ON

#define	L_IN_PGD	0
#define	L_IN_PGC	1

; PORTB
#define	L_B_DATA	1
#define	L_B_CLOCK	4

	include "C:\projects\picwriter_2005\wprotocol.h"


	cblock	0x20
	cmd1
	cmd2
	linewait
	syncwait
	count
	bytecount
	paramptr
	tmp_count

	ssw_tbits
	sswb_bits
	sswb_data
	ssw_tmp
	putparam_tmp_data

	lc_i

	ssr_count
	ssr_i
	ssr_j
	ssr_tbits
	ssr_data

	lastparam
	bsave

	PATMP1
	PATMP2

	wait_count

	cnt
	wait_ex0	; debug
	wait_ex1	; debug
	wait_ex2	; debug

	endc

	cblock	0x070
	endc

	cblock	0x120
	parambuf0:.64
	endc

	cblock	0x1a0
	parambuf1:.64
	endc
	

	org	0x0000
init:	goto	main
	org	0x0004
	retfie

dispatch:
	addwf	PCL, f
	goto	func_portcontrol
	goto	func_setsyncwait
	goto	func_setlinewait
	goto	func_hvread
	goto	func_serialsyncwrite
	goto	func_linecontrol
	goto	func_serialsyncread
	goto	func_info
	goto	func_capture_a
	goto	func_capture_b

PBMOD:
	andlw	b'00000011'
	addwf	PCL, f
	retlw	0
	retlw	1 << L_B_DATA
	retlw	1 << L_B_CLOCK
	retlw	(1 << L_B_DATA) | (1 << L_B_CLOCK)

; WRITERINFO of[^ t
;
; VPPd@\
; 128oCgobt@
; vgRo[W1
; PICn[hEFA
INFODATA:
	addwf	PCL, f
	retlw	0	; dummy
	retlw	IF4_HARDWARE_PIC
	retlw	IF3_VERSION_1
	retlw	IF2_BS_128
	retlw	IF1_CAP_ADVR
	retlw	ACK

main:
	banksel	OSCCON
	movlw	b'01110000'
	movwf	OSCCON

	banksel	PORTA
	movlw	b'11010000'
	movwf	PORTA
	clrf	PORTB
	banksel	ANSEL
	movlw	b'00000001'
	movwf	ANSEL
	banksel	ADCON0
	movlw	b'11000001'
	movwf	ADCON0
	banksel	ADCON1
	movlw	b'10000000'
	movwf	ADCON1

	banksel	TRISA
	movlw	b'11111111'
	movwf	TRISA	; CVH/CVL/CLK=OUT
	movlw	b'11101111'
	movwf	TRISB

	bcf	TRISB, 5
	bsf	TRISB, 2

	banksel	TXSTA
	movlw	b'00100100'
	movwf	TXSTA

	banksel	RCSTA
	movlw	b'10010000'
	movwf	RCSTA

	banksel	SPBRG
	movlw	.12
	movwf	SPBRG

	banksel	PORTA
	clrf	linewait
	clrf	syncwait

	movlw	'R'
	call	s_putc

	;goto	test_main
binio:
	call	s_getc
	movwf	cmd1

	movlw	SYN
	subwf	cmd1, w
	btfss	STATUS, Z
	goto	cmd1_not_syn
reply_syn:
	movlw	SYN
reply_char:
	call	s_putc
	goto	binio
cmd1_not_syn:
	; test b7
	btfsc	cmd1, 7
	goto	cmd1_b7_ok
reply_nak:
	movlw	NAK
	;movlw	'N'
	goto	reply_char
cmd1_b7_ok:
	; read cmd2
	call	s_getc
	movwf	cmd2
	movlw	SYN
	subwf	cmd2, w
	btfsc	STATUS, Z
	goto	reply_syn
	; test cmd2 b7
	btfss	cmd2, 7
	goto	reply_nak

	movlw	WP_MAX
	subwf	cmd1, w
	btfsc	STATUS, C
	goto	reply_nak

	movlw	0x7f
	andwf	cmd1, w
	goto	dispatch

reply_ack:
	movlw	ACK
	goto	reply_char

test_main:
	call	s_getc
	call	s_putc
	movlw	0x0d
	call	s_putc
	movlw	0x0a
	call	s_putc
	goto	test_main

	ifdef PARAMTEST
	movlw	0
	movwf	paramptr

	movlw	.128
	movwf	cnt
ll:
	movfw	paramptr
	call	putparam
	incf	paramptr, f
	decfsz	cnt, f
	goto	ll

	sleep

	banksel	ssw_data
	movlw	0xf0
	movwf	ssw_data
	movlw	.14
	movwf	ssw_bits
	call	serial_sync_write_bits
	endif
	sleep

; linecontrol/portcontorl
; 2bitclock/dataw胉Ĉߎws

PAMOD:
	movwf	PATMP1
	movwf	PATMP2
	rlf	PATMP1, f
	movlw	b'11000000'
	andwf	PATMP1, f
	movlw	b'00011111'
	andwf	PATMP2, w
	iorwf	PATMP1, w
	return


PORTBDATAMASK	equ	~((1 << L_B_DATA) | (1 << L_B_CLOCK))
TRISA_BASE	equ	b'00100011'	; AN0:RA0, \:RA1, MCLR:RA5 ͏ɓ

func_portcontrol:
	movlw	0x7f
	andwf	cmd2, w
	call	PAMOD
	iorlw	TRISA_BASE
	banksel	TRISA
	movwf	TRISA

	movfw	TRISB
	banksel	0
	andlw	PORTBDATAMASK
	movwf	bsave

	movfw	cmd2
	call	PBMOD
	iorwf	bsave, w
	banksel	TRISB
	movwf	TRISB
	
	banksel	0
	goto	reply_ack
func_setsyncwait:
	movlw	0x7f
	andwf	cmd2, w
	movwf	syncwait
	goto	reply_ack
func_setlinewait:
	movlw	0x7f
	andwf	cmd2, w
	movwf	linewait
	goto	reply_ack
func_serialsyncwrite:
	movlw	0x7f
	andwf	cmd2, w
	movwf	count
	movwf	bytecount
	movlw	.7
	addwf	bytecount, f
	rrf	bytecount, f
	rrf	bytecount, f
	rrf	bytecount, f
	movlw	b'00011111'
	andwf	bytecount, f
	
	clrf	paramptr
more_char:
	call	s_getc
	call	putparam
	incf	paramptr, f
	decfsz	bytecount, f
	goto	more_char

	; VAo͊Jn
	banksel	TRISB
	bcf	TRISB, L_B_DATA
	bcf	TRISB, L_B_CLOCK
	banksel	PORTB

	clrf	paramptr
	movfw	count
	movwf	tmp_count
ssw_02:
	movfw	tmp_count
	btfsc	STATUS, Z
	goto	end_loop

	movwf	ssw_tbits

	movlw	8
	subwf	ssw_tbits, w
	movlw	8
	btfsc	STATUS, C
	movwf	ssw_tbits

	movfw	ssw_tbits
	movwf	sswb_bits
	call	getparam
	movwf	sswb_data
	call	serial_sync_write_bits

	movfw	ssw_tbits
	subwf	tmp_count, f
	incf	paramptr, f
	goto	ssw_02
	
end_loop:
	banksel	TRISB
	bsf	TRISB, L_B_DATA
	banksel	PORTB
	goto	reply_ack

; input
; ssw_bits	o̓rbgJEg
serial_sync_write_bits:
	banksel	PORTB
L:
	bsf	PORTB, L_B_CLOCK

	movfw	PORTB	; PORTB  W Ƀ[h
	andlw	~(1 << L_B_DATA)	; W[L_DATA] = 0
	rrf	sswb_data, f	; ssw_dataE[e[g LSB->C
	btfsc	STATUS, C
	iorlw	1 << L_B_DATA	; LSB=1ȂL_DATAon
	movwf	PORTB	; PORTAɏ

	movfw	syncwait	; TSET1 EFCg
	call	wait_usec
	bcf	PORTB, L_B_CLOCK
	movfw	syncwait	; THLD1 EFCg
	call	wait_usec

	decfsz	sswb_bits, f
	goto L

	return

debug_wait_usec:	
;wait_usec:	
	movlw	1
	movwf	wait_ex2
dwu_loop2:
	movlw	0
	movwf	wait_ex1
dwu_loop1:
	movlw	0
	movwf	wait_ex0
dwu_loop0:
	decfsz	wait_ex0, f
	goto	dwu_loop0
	decfsz	wait_ex1, f
	goto	dwu_loop1
	decfsz	wait_ex2, f
	goto	dwu_loop2

	return
	
wait_usec:	
;real_wait_usec:	
	movwf	wait_count
	movlw	.127
	subwf	wait_count, w
	btfsc	STATUS, Z
	goto	debug_wait_usec

	movfw	wait_count

	iorlw	0
wu_loop	btfsc	STATUS, Z
	return
	nop
	nop
	nop
	addlw	0xff
	goto	wu_loop

; 01000000

prep_parambufptr	macro
	movfw	paramptr	; |C^FSR
	movwf	FSR
	bsf	STATUS, IRP	; IRP=1 (0x0120/0x01a0Ƃ IRP=1 ANZXGA)
	btfsc	FSR, 6	; FSR B6=>B7, 0=>B6 
	bsf	FSR, 7
	bcf	FSR, 6
	movlw	0x20	; FSR + 20
	addwf	FSR, f
	endm

; 0x0120 - 0x015f, 0x01a0 - 0x01df ̕sA128oCgobt@ANZX
putparam:
	movwf	putparam_tmp_data	; W Z[u

	prep_parambufptr

	movfw	putparam_tmp_data
	movwf	INDF
	goto	param_getset_common_ret

getparam:
	prep_parambufptr

	movfw	INDF
	movwf	lastparam
param_getset_common_ret:
	bcf	STATUS, IRP
	return
	
func_linecontrol:
	movlw	0x7f
	andwf	cmd2, f
	movfw	cmd2
	movwf	count
	movwf	lc_i
	clrf	paramptr
lc_01:
	call	s_getc
	call	putparam
	incf	paramptr, f
	decfsz	lc_i, f
	goto	lc_01

	movfw	count
	movwf	lc_i
	clrf	paramptr
lc_02:
	call	getparam
	call	PAMOD
	xorlw	b'11010000'	; ELV EHV EEX ͕_(Co[^[ăAiOXCb`)
	movwf	PORTA

	movfw	PORTB
	andlw	PORTBDATAMASK
	movwf	bsave
	movfw	lastparam
	call	PBMOD
	iorwf	bsave, w
	movwf	PORTB

	movfw	linewait
	call	wait_usec
	incf	paramptr, f
	decfsz	lc_i, f
	goto	lc_02
	goto	reply_ack
	
	
func_serialsyncread:
	banksel	TRISB
	bcf	TRISB, L_B_CLOCK
	bsf	TRISB, L_B_DATA
	banksel	PORTB

	movfw	cmd2
	andlw	0x7f
	movwf	ssr_count
	addlw	7
	movwf	bytecount
	rrf	bytecount, f
	rrf	bytecount, f
	rrf	bytecount, f
	movlw	0x0f
	andwf	bytecount, f

	movlw	ACK
	call	s_putc

	clrf	paramptr
	movfw	bytecount
	movwf	ssr_j

ssr_01:
	movfw	ssr_count
	movwf	ssr_tbits

	movlw	8
	subwf	ssr_tbits, w
	movlw	8
	btfsc	STATUS, C
	movwf	ssr_tbits

	movfw	ssr_tbits
	movwf	ssr_i

	clrf	ssr_data
ssr_02:
	bcf	STATUS, C
	rrf	ssr_data, f
	bsf	PORTB, L_B_CLOCK
	movfw	syncwait
	call	wait_usec
	btfsc	PORTB, L_B_DATA
	bsf	ssr_data, 7
	bcf	PORTB, L_B_CLOCK
	movfw	syncwait
	call	wait_usec
	decfsz	ssr_i, f
	goto	ssr_02

	;
	; f[^MSBVtgĂĂ̂ŁA
	; ǂݏo8bitɖȂꍇLSBACB
	;
	; 8-ssr_tbits(ǂݏorbg)EVtg
	; ssr_tbits=8̂Ƃ̃[v򏈗ȗ̂߁A
	; 1rbg[e[gĂ 9-ssr_tbitsE[e[g
	; (0 < ssr_tbits <= 8)
	; 
	movlw	9
	movwf	ssr_i
	movfw	ssr_tbits
	subwf	ssr_i, f

	rlf	ssr_data, f
ssr_03:	rrf	ssr_data, f
	decfsz	ssr_i, f
	goto	ssr_03

	movfw	ssr_data
	call	s_putc

	movfw	ssr_tbits
	subwf	ssr_count, f

	decfsz	ssr_j, f
	goto	ssr_01

	goto	binio


func_info:
	movlw	5
	movwf	count
fi01:
	movfw	count
	call	INFODATA
	call	s_putc
	decfsz	count, f
	goto	fi01
	goto	binio


func_capture_a:
func_capture_b:
	goto	reply_nak

func_hvread:
	movlw	ACK
	call	s_putc
	banksel	ADCON0
	bsf	ADCON0, GO_DONE
wait_ad:	btfsc	ADCON0, GO_DONE
	goto	wait_ad

	banksel	ADRESL
	movfw	ADRESL
	call	s_putc
	banksel	ADRESH
	movfw	ADRESH
	call	s_putc
	banksel	PORTA
	goto	binio

s_putc:
	; wait TSR empty
	banksel	PIR1
wait_txif:
	btfss	PIR1, TXIF
	goto	wait_txif
	banksel	TXREG
	movwf	TXREG
	return

s_getc:
	banksel	PIR1
wait_rcif:
	btfss	PIR1, RCIF
	goto	wait_rcif
	movfw	RCREG
	return

	

	end
