// pw.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#pragma warning(disable: 4192)
#import "../NWriterObjects/debug/NWriterObjects.dll" raw_interfaces_only, raw_native_types, no_namespace, named_guids 

class ticks {
public:
	DWORD	tbuf[10000];
	char	cbuf[10000];
	int		tindex;
	bool	enabled;
	ticks() {
		enabled = false;
		tindex = 0;
	}
	void add(int c = ' ') {
		if (!enabled)
			return;
		if (tindex < 10000) {
			tbuf[tindex] = GetTickCount();
			cbuf[tindex] = c;
			tindex++;
		}
	}
	void enable(bool b) {
		enabled = b;
	}
	void dump() {
		DWORD	lp;
		int		i;

		lp = tbuf[0];
		for (i = 0; i < tindex; i++) {
			fprintf(stderr, "%10d: %c %5d\n", tbuf[i], cbuf[i], tbuf[i] - lp);
			lp = tbuf[i];
		}
	}
};

ticks	t;


class HRESUTEXCEPTION {
public:
	HRESULT	hr;
	HRESUTEXCEPTION(HRESULT r) : hr(r) {
	}
};

void ThrowIfFail(HRESULT r)
{
	if (FAILED(r)) {
		AtlTrace("Throwing COM failure exception %08x\n", r);
		throw HRESUTEXCEPTION(r);
	}
}

struct PIC_CHARACTERISTICS {
	int	memory_size;	// Total memory size of HEX, including pseudo storage for data area (typically begin at 0x2100)
	int	tprog2;			// Programming cycle time (externally timed)
	int	tera;
	int	program_memory_size;
	int	config_offset;
	int	config_length;
	int	programming_algorthm;
};

PIC_CHARACTERISTICS PIC16F887 = {
	0x2200,
	3, 6,
	0x2000,
	0x2000, 10,
};

PIC_CHARACTERISTICS* pTargetPIC = &PIC16F887;

HRESULT ReadMemoryWord(IMemory* pMemory, WORD* value, int wordaddress)
{
	BYTE	l, h;
	HRESULT r;

	r = pMemory->ReadByte(wordaddress * 2, &l);
	if (FAILED(r))
		return r;
	r = pMemory->ReadByte(wordaddress * 2 + 1, &h);
	if (FAILED(r))
		return r;
	*value = MAKEWORD(l, h) & 0x3fff;
	return S_OK;
}

int test887()
{
	HRESULT r;
	CComPtr<IMemory> pMemory;
	CComPtr<IComPort> pComPort;
	CComPtr<IDeviceInitializer> pInit;
	CComPtr<IWriterController> pController;
	CComVariant v;
	int		i;
	int		errors = 0;

	r = CoCreateInstance(CLSID_HexLoader, NULL, CLSCTX_INPROC, IID_IMemory, (void **)&pMemory.p);
	ThrowIfFail(r);
	r = pMemory->Allocate(pTargetPIC->memory_size * 2);	// PRGRAM 0000-1FFF USERID=2000-2003 CONFIG=2008-2009 DATA=2100-21FF, IN WORDS
	ThrowIfFail(r);
	r = pMemory->Load(L"c:/documents/pic/887test/887test.hex", 0);
	ThrowIfFail(r);

	r = CoCreateInstance(CLSID_ComPort, NULL, CLSCTX_INPROC, IID_IComPort, (void **)&pComPort.p);
	ThrowIfFail(r);
	r = CoCreateInstance(CLSID_H8DeviceInitializer, NULL, CLSCTX_INPROC, IID_IDeviceInitializer, (void **)&pInit.p);
	ThrowIfFail(r);
	r = pComPort->Open(L"COM1: baud=38400 parity=N data=8 stop=1");
	ThrowIfFail(r);
	r = pInit->Initialize(pComPort, L"c:/cygwin/home/naoshi/src/x818/x818.srec", v);
	ThrowIfFail(r);
	r = CoCreateInstance(CLSID_WriterController, NULL, CLSCTX_INPROC, IID_IWriterController, (void **)&pController.p);
	ThrowIfFail(r);
	r = pController->AttachPort(pComPort);
	ThrowIfFail(r);
	
	BYTE	infobytes[4];
	r = pController->InfoRaw(infobytes);
	ThrowIfFail(r);

	r = pController->SetSyncWait(1);
	r = pController->SetLineWait(1000);
	r = pController->PortControl(0x01);
	ThrowIfFail(r);

	CComPtr<IPWSequencer> pSeq;

	r = CoCreateInstance(CLSID_PWSeqStartVDD, NULL, CLSCTX_INPROC, IID_IPWSequencer, (void **)&pSeq.p);
	ThrowIfFail(r);
	r = pSeq->Run(pController, NULL, NULL);
	ThrowIfFail(r);

	CComPtr<IPICWriter> pWriter;
	r = CoCreateInstance(CLSID_PICWriter, NULL, CLSCTX_INPROC, IID_IPICWriter, (void **)&pWriter.p);
	ThrowIfFail(r);
	r = pWriter->put_pController(pController);
	ThrowIfFail(r);

#if 0
	// Erase ALL
	r = pWriter->LoadConfiguration();
	ThrowIfFail(r);
	for (int i = 0; i < 9; i++) {
		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}
	r = pWriter->BulkEraseProgramMemory();
	ThrowIfFail(r);
	Sleep(pTargetPIC->tera);
	return 0;
#endif


	int	program_memory_size = pTargetPIC->program_memory_size;
	int	alg_word_size = 8;
	int	alg_byte_size = alg_word_size * 2;
	int endmem;
	BYTE flags;

	endmem = program_memory_size * 2;
	while (endmem-- >= 0) {
		r = pMemory->GetFlags(endmem, &flags);
		if (flags & MF_FILLED)
			break;
	}
	endmem = (endmem + alg_byte_size - 1) / alg_byte_size * alg_word_size;

#if 1
	r = pWriter->BulkEraseProgramMemory();
	ThrowIfFail(r);
	Sleep(pTargetPIC->tera);

	t.enable(true);
	t.add();

	for (i = 0; i < endmem; i++) {
		WORD data;

		r = ReadMemoryWord(pMemory, &data, i);
		ThrowIfFail(r);

		r = pWriter->LoadDataForProgramMemory(data);
		ThrowIfFail(r);
		//fprintf(stderr, "Loading %04x : %04x\n", i, data);

		if ((i % alg_word_size) == (alg_word_size - 1)) {

			//fprintf(stderr, "Programming %04x\n", i);
			r = pWriter->BeginProgrammingET();
			ThrowIfFail(r);

			Sleep(pTargetPIC->tprog2);

			r = pWriter->EndProgramming();
			ThrowIfFail(r);

		}
		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}

	t.add();

	r = pSeq->Run(pController, NULL, NULL);
	ThrowIfFail(r);

	for (i = 0; i < endmem; i++) {
		WORD	data;
		long	rdata;

		r = ReadMemoryWord(pMemory, &data, i);
		ThrowIfFail(r);

		r = pWriter->ReadDataFromProgramMemory(&rdata);
		ThrowIfFail(r);

		if (data != rdata) {
			errors++;
			AtlTrace("Verify failure\n");
		}

		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}

	t.enable(true);
	t.add();
	t.dump();

	r = pWriter->LoadConfiguration();
	ThrowIfFail(r);

	// RtBO[V ONE WORD ASY
	for (i = 0; i < pTargetPIC->config_length; i++) {
		WORD	data;

		r = ReadMemoryWord(pMemory, &data, pTargetPIC->config_offset + i);
		ThrowIfFail(r);

		fprintf(stderr, "Loading Data %04x\n", data);

		r = pWriter->LoadDataForProgramMemory(data);
		ThrowIfFail(r);
		
		r = pWriter->BeginProgrammingET();
		ThrowIfFail(r);

		Sleep(pTargetPIC->tprog2);	// ʐMI[o[wbĥŁAKv͑҂ԂTPROG2肩Ȃ菭ȂȂ邪]TTPROG2܂
		
		r = pWriter->EndProgramming();
		ThrowIfFail(r);

		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}


	r = pSeq->Run(pController, NULL, NULL);
	ThrowIfFail(r);

	r = pWriter->LoadConfiguration();
	ThrowIfFail(r);

	// RtBO[V ONE WORD ASY
	for (i = 0; i < pTargetPIC->config_length; i++) {
		WORD	data;
		long	rdata;

		int addr = pTargetPIC->config_offset + i;

		r = ReadMemoryWord(pMemory, &data, addr);
		ThrowIfFail(r);
		r = pMemory->GetFlags(addr * 2, &flags);
		ThrowIfFail(r);
		if (flags & MF_FILLED) {
			fprintf(stderr, "Loading Data %04x\n", data);

			r = pWriter->ReadDataFromProgramMemory(&rdata);
			ThrowIfFail(r);

			if (rdata != data) {
				AtlTrace("%04d: Verify failure\n", addr);
				errors++;
			}
		}
		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}

	fprintf(stderr, "errors = %d\n", errors);

#else
	for (i = 0; i < program_memory_size; i++) {
		WORD	data;
		long	rdata;

		r = ReadMemoryWord(pMemory, &data, i);
		ThrowIfFail(r);

		r = pWriter->ReadDataFromProgramMemory(&rdata);
		ThrowIfFail(r);

		fprintf(stderr, "%04x: Data read as %04x\n", i, rdata);
		if (data != rdata) {
			fprintf(stderr, "verify error\n");
		}
		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}

	r = pWriter->LoadConfiguration();
	ThrowIfFail(r);

	for (i = 0; i < 10; i++ ) {
		long data;

		r = pWriter->ReadDataFromProgramMemory(&data);
		ThrowIfFail(r);
		fprintf(stderr, "%04x: Data read as %04x\n", pTargetPIC->config_offset + i, data);

		r = pWriter->IncrementAddress();
		ThrowIfFail(r);
	}
#endif
		return 0;
}

void ScriptTest()
{
	HRESULT r;
	CComPtr<IMemory> pMemory;
	CComPtr<IComPort> pComPort;
	CComPtr<IDeviceInitializer> pInit;
	CComPtr<IWriterController> pController;
	CComVariant v;
	int		errors = 0;

	r = CoCreateInstance(CLSID_HexLoader, NULL, CLSCTX_INPROC, IID_IMemory, (void **)&pMemory.p);
	ThrowIfFail(r);
	r = pMemory->Allocate(pTargetPIC->memory_size * 2);	// PRGRAM 0000-1FFF USERID=2000-2003 CONFIG=2008-2009 DATA=2100-21FF, IN WORDS
	ThrowIfFail(r);
	r = pMemory->Load(L"c:/documents/pic/887test/887test.hex", 0);
	ThrowIfFail(r);

	r = CoCreateInstance(CLSID_ComPort, NULL, CLSCTX_INPROC, IID_IComPort, (void **)&pComPort.p);
	ThrowIfFail(r);
	r = CoCreateInstance(CLSID_H8DeviceInitializer, NULL, CLSCTX_INPROC, IID_IDeviceInitializer, (void **)&pInit.p);
	ThrowIfFail(r);
	r = pComPort->Open(L"COM1: baud=38400 parity=N data=8 stop=1");
	ThrowIfFail(r);
	r = pInit->Initialize(pComPort, L"c:/cygwin/home/naoshi/src/x818/x818.srec", v);
	ThrowIfFail(r);
	r = CoCreateInstance(CLSID_WriterController, NULL, CLSCTX_INPROC, IID_IWriterController, (void **)&pController.p);
	ThrowIfFail(r);
	r = pController->AttachPort(pComPort);
	ThrowIfFail(r);

	CComPtr<IPICWriter> pWriter;
	r = CoCreateInstance(CLSID_PICWriter, NULL, CLSCTX_INPROC, IID_IPICWriter, (void **)&pWriter.p);
	ThrowIfFail(r);
	r = pWriter->put_pController(pController);
	ThrowIfFail(r);

	CComPtr<IScriptUtil> pScriptUtil;
	r = CoCreateInstance(CLSID_ScriptUtil, NULL, CLSCTX_INPROC, IID_IScriptUtil, (void **)&pScriptUtil.p);

	CComPtr<IPWScript> pScripts;
	r = CoCreateInstance(CLSID_PWScript, NULL, CLSCTX_INPROC, IID_IPWScript, (void **)&pScripts.p);
	ThrowIfFail(r);

	r = pScripts->AddGlobal(L"PICWriter", pWriter);
	ThrowIfFail(r);
	r = pScripts->AddGlobal(L"Memory", pMemory);
	ThrowIfFail(r);
	r = pScripts->AddGlobal(L"Port", pComPort);
	ThrowIfFail(r);
	r = pScripts->AddGlobal(L"Controller", pController);
	ThrowIfFail(r);
	r = pScripts->AddGlobal(L"Util", pScriptUtil);
	ThrowIfFail(r);

	r = pScripts->AddScriptFile(L"Test.vbs");
	ThrowIfFail(r);

	r = pScripts->Execute(L"ReadDeviceId");
	//r = pScripts->Execute(L"Program887");
	//r = pScripts->Execute(L"Reset_LVP");
	//r = pScripts->Execute(L"ProgramEightWordAlgorthm");
}

int _tmain(int argc, _TCHAR* argv[])
{
	HRESULT r;
	
	try {
		r = CoInitializeEx(NULL, COINIT_MULTITHREADED);
		ThrowIfFail(r);

		//test887();

		ScriptTest();
	}
	catch(...) {
		return 1;
	}
	return 0;
}