// CalibrationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pww.h"
#include "CalibrationDlg.h"
#include "VoltageCalculator.h"


// CCalibrationDlg dialog

IMPLEMENT_DYNAMIC(CCalibrationDlg, CDialog)

CCalibrationDlg::CCalibrationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCalibrationDlg::IDD, pParent)
{

}

CCalibrationDlg::~CCalibrationDlg()
{
}

void CCalibrationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_V1, m_v1);
	DDX_Control(pDX, IDC_AD1, m_ad1);
	DDX_Control(pDX, IDC_V2, m_v2);
	DDX_Control(pDX, IDC_AD2, m_ad2);
}


BEGIN_MESSAGE_MAP(CCalibrationDlg, CDialog)
END_MESSAGE_MAP()


// CCalibrationDlg message handlers

void CCalibrationDlg::OnOK()
{
	double	v1, v2, ad1, ad2;
	CString	str;

	m_v1.GetWindowText(str);
	v1 = _wtof(str);
	m_v2.GetWindowText(str);
	v2 = _wtof(str);
	m_ad1.GetWindowText(str);
	ad1 = _wtof(str);
	m_ad2.GetWindowText(str);
	ad2 = _wtof(str);

	wchar_t buf[128];

	_snwprintf(buf, sizeof(buf) / sizeof(*buf), L"%f %f %f %f", v1, ad1, v2, ad2);
	AfxGetApp()->WriteProfileString(szWriter, szVoltageCalibration, buf);

	CDialog::OnOK();
}

BOOL CCalibrationDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CVoltageCalculator calc;

	wchar_t buf[32];

	calc.load();

	_snwprintf(buf, sizeof(buf) / sizeof(*buf), L"%.3f", calc.m_y1);
	m_v1.SetWindowText(buf);
	_snwprintf(buf, sizeof(buf) / sizeof(*buf), L"%d", (int)calc.m_x1);
	m_ad1.SetWindowText(buf);
	_snwprintf(buf, sizeof(buf) / sizeof(*buf), L"%.3f", calc.m_y2);
	m_v2.SetWindowText(buf);
	_snwprintf(buf, sizeof(buf) / sizeof(*buf), L"%d", (int)calc.m_x2);
	m_ad2.SetWindowText(buf);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
