// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "pww.h"
#include "ChildView.h"
#include "DeviceSelectionDlg.h"
#include "ProgressDlg.h"
#include "CommDlg.h"
#include "VoltageDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define ACTION_MENU_POS	4
typedef map<UINT, CMenuAction*> actionmap_t;

actionmap_t g_actionmap;
CMenuAction* g_action;

LPCWSTR	pszEnvironment = L"Environment";

// CChildView

CChildView::CChildView()
: m_pDeviceEntry(NULL)
, m_filename(_T(""))
{
	wchar_t buf[MAX_PATH];

	GetCurrentDirectory(sizeof(buf), buf);
	curdir = buf;
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView, CWnd)
	ON_WM_PAINT()
	ON_COMMAND(ID_FILE_OPEN, &CChildView::OnFileOpen)
	ON_WM_CREATE()
//	ON_COMMAND(ID_ACTION_PROGRAM, &CChildView::OnActionProgram)
	ON_COMMAND(ID_CONFIGURATION_DEVICE, &CChildView::OnConfigurationDevice)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_DEVICE, &CChildView::OnUpdateIndicatorDevice)
	ON_COMMAND(ID_FILE_RELOAD, &CChildView::OnFileReload)
	ON_UPDATE_COMMAND_UI(ID_FILE_RELOAD, &CChildView::OnUpdateFileReload)
	ON_WM_SIZE()
	ON_COMMAND_RANGE(ID_ACTION_DYN0, ID_ACTION_DYN9, OnActionDyn)
	ON_UPDATE_COMMAND_UI_RANGE(ID_ACTION_DYN0, ID_ACTION_DYN9, OnUpdateActionDyn)
	ON_COMMAND(ID_FILE_NEW, &CChildView::OnFileNew)
	ON_COMMAND(ID_CONFIGURATION_COMMPORT, &CChildView::OnConfigurationCommport)
	ON_COMMAND(ID_CONFIGURATION_VOLTAGE, &CChildView::OnConfigurationVoltage)
END_MESSAGE_MAP()



// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

	return TRUE;
}

	list<wstring> m_lines;

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	list<wstring>::iterator it;
	TEXTMETRIC	tm;

	CFont	font;
	font.CreateStockObject(SYSTEM_FIXED_FONT);

	dc.SaveDC();
	dc.SelectObject(&font);

	dc.GetTextMetrics(&tm);

	int	y;
	y = 0;
	for (it = m_lines.begin(); it != m_lines.end(); it++) {
		dc.TextOut(0, y, it->c_str(), (int)it->size());
		y += tm.tmHeight + tm.tmExternalLeading;
	}

	dc.RestoreDC(-1);
}


void CChildView::OnFileOpen()
{
	CFileDialog dialog(TRUE, L"hex", NULL, OFN_HIDEREADONLY, L"Intel HEX format(*.hex)|*.hex|All files(*.*)|*.*||", this);
	if (dialog.DoModal() != IDOK)
		return;

	m_filename = dialog.GetPathName();
	if (!HexReload()) {
		AfxMessageBox(L"Failed");
		return;
	}
	AfxGetApp()->WriteProfileString(pszEnvironment, L"hexfile", m_filename);
}

void CChildView::BuildHexLines(void)
{
	HRESULT r;
	int	have_data;
	BYTE*	pData;
	BYTE*	pFlags;
	ULONG	nSize;
	ULONG	i, j;
	wchar_t	hex[32];
	wstring	line;
	ULONG	addr;
	int		nodata_count = 1;

	r = g_memory->GetPointer(&pData, &pFlags, &nSize);

	CString text;
	
	text = "";
	m_lines.clear();
	for (i = 0; i < nSize; i += 16) {
		have_data = 0;
#if 0
		_snwprintf(hex, sizeof(hex) / sizeof(wchar_t), L"%08X: ", i);
		line = hex;
		for (j = 0; j < 16; j++) {
			addr = i + j;
			have_data |= pFlags[addr] & 1;
			if (pFlags[addr] & 1) {
				_snwprintf(hex, sizeof(hex) / sizeof(wchar_t), L" %02X", pData[addr]);
				line += hex;
			} else {
				line += L" __";
			}
		}
#else
		_snwprintf(hex, sizeof(hex) / sizeof(wchar_t), L"%08X: ", i / 2);
		line = hex;
		for (j = 0; j < 16; j += 2) {
			addr = i + j;
			have_data |= pFlags[addr] & 1;
			if (pFlags[addr] & 1) {
				_snwprintf(hex, sizeof(hex) / sizeof(wchar_t), L" %02X%02X", pData[addr + 1], pData[addr]);
				line += hex;
			} else {
				line += L" ____";
			}
		}

#endif
		if (have_data) {
			m_lines.push_back(line);
			text += line.c_str();
			text += "\r\n";
			nodata_count = 0;
		} else {
			if (nodata_count == 0) {
				m_lines.push_back(L"");
				text += "";
				text += "\r\n";
			}
			nodata_count++;
		}
	}
	m_edit.SetWindowText(text);
}

int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;


	CFont	font;

	font.CreateStockObject(SYSTEM_FIXED_FONT);

	m_edit.Create(WS_VISIBLE | ES_MULTILINE | ES_READONLY | ES_AUTOHSCROLL | ES_AUTOVSCROLL | WS_VSCROLL | WS_HSCROLL, CRect(0, 0, 100, 100), this, 1);
	m_edit.SetFont(&font);

	CString fn;
	CString	dn;
	
	fn = AfxGetApp()->GetProfileString(pszEnvironment, L"hexfile", L"");
	if (fn != "") {
		m_filename = fn;
		HexReload();
	}
	m_devices.load();

	fn = AfxGetApp()->GetProfileString(pszEnvironment, L"DeviceConfigFile", L"");
	dn = AfxGetApp()->GetProfileString(pszEnvironment, L"DeviceConfigEntry", L"");
	
	CDeviceEntry* pdev = m_devices.find(fn, dn);
	SetDeviceEntry(pdev);

	return 0;
}

void CChildView::CreateInstance(REFCLSID clsid, REFIID riid, LPVOID* ppv)
{
	return ::CreateInstance(clsid, riid, ppv);
}

void CChildView::ScriptThread()
{
}

//void CChildView::OnActionProgram()
//{
//}

CMenuActionList actions;

void CChildView::OnConfigurationDevice()
{
	CDeviceSelectionDlg dialog(this);

	dialog.m_pDevices = &m_devices;
	dialog.m_pSelectedDevice = m_pDeviceEntry;
	if (dialog.DoModal() != IDOK)
		return;
	SetDeviceEntry(dialog.m_pSelectedDevice);
	
}

void CChildView::OnUpdateIndicatorDevice(CCmdUI *pCmdUI)
{
	if (m_pDeviceEntry == NULL) {
		pCmdUI->SetText(L"");
	} else {
		pCmdUI->SetText(m_pDeviceEntry->m_DeviceName.c_str());
	}
}

bool CChildView::HexReload(void)
{
	HRESULT r;
	r = g_memory->Load((BSTR)(LPCWSTR)m_filename, 0);
	if (FAILED(r)) {
		return false;
	}
	BuildHexLines();
	Invalidate();
	return true;
}

void CChildView::OnFileReload()
{
	if (!HexReload()) {
		AfxMessageBox(IDS_HEXRELOAD_FAILED);
	}
}

void CChildView::OnUpdateFileReload(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(m_filename != "");
}

void CChildView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	m_edit.SetWindowPos(NULL, 0, 0, cx, cy, SWP_NOMOVE | SWP_NOZORDER);
}

HANDLE hThread;

void CChildView::OnActionDyn(UINT nID)
{
	actionmap_t::iterator it;
	it = g_actionmap.find(nID);
	if (it == g_actionmap.end())
		return;


	CProgressDlg dlg;

	dlg.m_action = it->second;

	dlg.DoModal();

	BuildHexLines();
	Invalidate();
}

void CChildView::OnUpdateActionDyn(CCmdUI* pCmdUI)
{
	actionmap_t::iterator it;
	it = g_actionmap.find(pCmdUI->m_nID);
	if (it == g_actionmap.end())
		return;
	pCmdUI->Enable(TRUE);
}

void CChildView::SetDeviceEntry(CDeviceEntry* pDeviceEntry)
{
	m_pDeviceEntry = pDeviceEntry;

	CMenu* pMenu = AfxGetMainWnd()->GetMenu();
	CMenu* submenu = pMenu->GetSubMenu(ACTION_MENU_POS);
	while (submenu->GetMenuItemCount() > 0)
		submenu->RemoveMenu(0, MF_BYPOSITION);

	if (pDeviceEntry == NULL)
		return;

	CMenuActionList ::iterator it;
	UINT	id = ID_ACTION_DYN0;

	actions.clear();
	m_pDeviceEntry->GetActions(actions);
	for (it = actions.begin(); it != actions.end(); it++) {
		if ((*it)->isSeparator()) {
			submenu->AppendMenu(MF_SEPARATOR);
		} else {
			CMenuAction* ap = dynamic_cast<CMenuAction*>(*it);
			ASSERT(ap != NULL);
			submenu->AppendMenu(MF_STRING, id, ap->m_strMenuText.c_str());
			g_actionmap[id] = ap;
			id++;
		}
	}
	AfxGetApp()->WriteProfileString(pszEnvironment, L"DeviceConfigFile", m_pDeviceEntry->m_FileName.c_str());
	AfxGetApp()->WriteProfileString(pszEnvironment, L"DeviceConfigEntry", m_pDeviceEntry->m_DeviceName.c_str());
}

void CChildView::OnFileNew()
{
	g_memory->InitNew();
	BuildHexLines();
	Invalidate();
}

void CChildView::OnConfigurationCommport()
{
	CCommDlg	dlg;

	dlg.DoModal();
}

void CChildView::OnConfigurationVoltage()
{
	CVoltageDlg dlg;

	dlg.DoModal();
}
