// DeviceSelectionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pww.h"
#include "DeviceSelectionDlg.h"


// CDeviceSelectionDlg dialog

IMPLEMENT_DYNAMIC(CDeviceSelectionDlg, CDialog)

CDeviceSelectionDlg::CDeviceSelectionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDeviceSelectionDlg::IDD, pParent)
	, m_pDevices(NULL), m_pSelectedDevice(NULL)
{

}

CDeviceSelectionDlg::~CDeviceSelectionDlg()
{
}

void CDeviceSelectionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DEVICE, m_comboDevice);
}


BEGIN_MESSAGE_MAP(CDeviceSelectionDlg, CDialog)
END_MESSAGE_MAP()


// CDeviceSelectionDlg message handlers

BOOL CDeviceSelectionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CDevices::iterator it;
	int	index;

	for (it = m_pDevices->begin(); it != m_pDevices->end(); it++) {
		index = m_comboDevice.AddString((*it)->m_DeviceName.c_str());
		m_comboDevice.SetItemDataPtr(index, (*it));
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDeviceSelectionDlg::OnOK()
{
	int	index;

	index = m_comboDevice.GetCurSel();
	if (index == CB_ERR)
		return;

	m_pSelectedDevice = (CDeviceEntry *)m_comboDevice.GetItemDataPtr(index);

	CDialog::OnOK();
}
