#include "stdafx.h"
#include "pww.h"
#include "ScriptThread.h"
#include "VoltageCalculator.h"

HRESULT CScriptThread::CreateObjects()
{
	CComVariant v;
	CString	dcbstr;

	try {
		dcbstr = AfxGetApp()->GetProfileString(szWriter, szPort, szPortDefault);

		CreateInstance(CLSID_ComPort, IID_IComPort, (void **)&m_pComPort.p);
		E(m_pComPort->Open((BSTR)(LPCWSTR)dcbstr));

		m_pProgress = g_notify;
	}
	catch(HRESULTEXCEPTION& e) {
		return e.hr;
	}
	return S_OK;
}


DWORD CScriptThread::Main()
{
	HRESULT r;
	CComVariant v;
	int		errors = 0;
	CComPtr<IScriptUtil>	pScriptUtil;
	CComPtr<IPICWriter>		pWriter;
	CComPtr<IWriterController>		pController;
	CVoltageCalculator vcalc;

	CComPtr<IProfileValues> pValues;

	LONG n;
	wchar_t	buf[1000];
	double vpp;

	vcalc.load();


	SetCurrentDirectory(curdir.c_str());

	try {
		//r = CoInitializeEx(NULL, COINIT_MULTITHREADED);
		r = CoInitialize(NULL);
		ThrowIfFail(r);

		CreateInstance(CLSID_WriterController, IID_IWriterController, (void **)&pController.p);
		E(pController->AttachPort(m_pComPort));

		CComPtr<IDeviceInitializer> pDevInit;
		CreateInstance(CLSID_H8DeviceInitializer, IID_IDeviceInitializer, (void **)&pDevInit.p);
		E(pDevInit->Initialize(m_pComPort, L"c:/cygwin/home/naoshi/src/x818/x818.srec", v));

		r = pController->AnalogRead(0, &n);
		if (SUCCEEDED(r)) {
			vpp = vcalc.Convert(n);
			r = m_pProfile->get_ArrayVal(L"VPP", AVT_DOUBLE, &pValues.p);
			if (SUCCEEDED(r)) {
				CComVariant	vmin, vmax;

				r = pValues->get_Count(&n);
				if (n != 2) {
					E(E_INVALIDARG);
				}
				E(pValues->get_Item(1, &vmin));
				E(pValues->get_Item(2, &vmax));
				vmin.ChangeType(VT_R8);
				vmax.ChangeType(VT_R8);
				if (vpp < vmin.dblVal || vpp > vmax.dblVal) {
					_snwprintf(buf, sizeof(buf) / sizeof(*buf),
						L"VPP voltage exceeds limit %.1f %.1f %.1f", vmax.dblVal, vmax.dblVal, vpp);
					E(E_FAIL);
				}
			}
		}

		CreateInstance(CLSID_PICWriter, IID_IPICWriter, (void **)&pWriter.p);
		E(pWriter->put_pController(pController));

		CreateInstance(CLSID_ScriptUtil, IID_IScriptUtil, (void **)&pScriptUtil.p);

		E(m_pScriptSite->SetSiteWindow((long)m_hScriptSiteWnd));

		E(m_pScriptSite->AttachEngine(m_pEngine));

		CComBSTR	inc;
		CComPtr<IProfileValues> pValues;
		wchar_t buf[MAX_PATH];
		wchar_t* fp;

		E(m_pScriptSite->InitScript());

		r = m_pProfile->get_ArrayVal(L"include", AVT_STRING, &pValues);
		if (r == S_OK) {
			long n, i;
			E(pValues->get_Count(&n));
			for (i = 1; i <= n; i++) {
				CComVariant v;

				E(pValues->get_Item(i, &v));
				r = v.ChangeType(VT_BSTR);
				if (FAILED(r))
					continue;
				GetFullPathName(v.bstrVal, sizeof(buf) / sizeof(*buf), buf, &fp);
				E(m_pScriptSite->AddScriptFile(buf));
			}
		}

		GetFullPathName(m_script.c_str(), sizeof(buf) / sizeof(*buf), buf, &fp);
		E(m_pScriptSite->AddScriptFile(buf));
		

#if 0
		SCRIPTTHREADSTATE	sst;
		SCRIPTSTATE	ss;


		r = m_pEngine->GetScriptState(&ss);
		r = m_pEngine->GetScriptThreadState(SCRIPTTHREADID_CURRENT, &sst);
#endif

		E(m_pScriptSite->AddGlobal(L"PICWriter", pWriter));
		E(m_pScriptSite->AddGlobal(L"Memory", m_pMemory));
		E(m_pScriptSite->AddGlobal(L"Port", m_pComPort));
		E(m_pScriptSite->AddGlobal(L"Controller", pController));
		E(m_pScriptSite->AddGlobal(L"Util", pScriptUtil));
		E(m_pScriptSite->AddGlobal(L"Profile", m_pProfile));
		E(m_pScriptSite->AddGlobal(L"Progress", m_pProgress));

		E(m_pScriptSite->Execute((BSTR)m_pAction->m_strSubEntry.c_str()));
		PostMessage(m_hTermNotifyWnd, m_uTermNotifyMsg, 0, 0);
	}
	catch (HRESULTEXCEPTION& ex) {
		E(m_pEngine->SetScriptState(SCRIPTSTATE_CLOSED));
		PostMessage(m_hTermNotifyWnd, m_uTermNotifyMsg, 0, ex.hr);
	}
	return 0;
}

DWORD __stdcall ScriptThreadMain(CScriptThread* pParam)
{
	CScriptThread* pThis = (CScriptThread *)pParam;
	DWORD r;

	r = pThis->Main();
	return r;
}

