' PIC16F87/88 ݃[`
'
' ̏ MICROCHIP  PIC16F87/88 Flash Memory Programming Specification 
' QƂċLqĂ܂
' http://ww1.microchip.com/downloads/en/DeviceDoc/39607b.pdf
'

option Explicit

const BULK_ERASE_PROGRAM_MEMORY = &h09
const BULK_ERASE_DATA_MEMORY = &h0b
const BEGIN_ERASE = &h08
const BEGIN_PROGRAMMING_ONLY = &h18
const END_PROGRAMMING = &h17
const CHIP_ERASE = &h1f
const TPROG2 = 2

dim memoryUsed

class PIC16F87_88
	sub ProgramProgramMemory
		dim endaddr
		dim data
		dim addr
		dim	i
		
		progress.ProgressText = "Writing Program Memory"
		progress.NotifyText = ""

		endaddr = cint((memoryUsed + 31) / 32) * 32
		
		PICWriter.LoadDataForProgramMemory &h01
		addr = 0
		do while addr < endaddr
			Progress.SetBar 0, endaddr - 1, addr
			
			PICWriter.command6 BEGIN_ERASE
			Util.Sleep tprog2
			PICWriter.command6 END_PROGRAMMING

			for i = 0 to 31
				data = Memory.ReadWord(addr)
				PICWriter.LoadDataForProgramMemory data
				if (i mod 4) = 3 then
					PICWriter.command6 BEGIN_PROGRAMMING_ONLY
					Util.Sleep 3
					PICWriter.command6 END_PROGRAMMING
				end if
				PICWriter.IncrementAddress
				addr = addr + 1
			next
		loop
	end sub

	sub ProgramDataMemory
		dim endaddr
		dim data
		dim addr
		dim	i
		dim org
		dim size

		progress.ProgressText = "Writing Data Memory"
		progress.NotifyText = ""
		
		org = Profile.int("DataMemoryOrg")
		size = Profile.Int("DataMemorySize")
		
		PICWriter.LoadDataForDataMemory &h01

		'
		' PC user memory ɂꍇAvO[ARtBO[V(0x2000-) ͏Ȃ
		'
		PICWriter.command6 BULK_ERASE_DATA_MEMORY
		PICWriter.command6 BEGIN_ERASE
		Util.Sleep tprog2
		PICWriter.command6 END_PROGRAMMING
		
		addr = 0
		endaddr = addr + size
		do while addr < endaddr
			Progress.SetBar 0, endaddr - 1, addr
			for i = 0 to 31
				Progress.SetBar 0, endaddr - 1, addr
				data = Memory.ReadWord(addr + org) and &hff
				PICWriter.LoadDataForDataMemory data
				PICWriter.command6 BEGIN_PROGRAMMING_ONLY
				Util.Sleep 3
				PICWriter.command6 END_PROGRAMMING
				PICWriter.IncrementAddress
				addr = addr + 1
			next
		loop
	end sub

	sub ProgramConfigMemory
		dim addr
		dim vaddr
		dim data
		dim org
		dim size

		dim px
		set px = Profile.ArrayVal("ProgramExclude", AVT_INTEGER)
		
		org = Profile.Int("ConfigMemoryOrg")
		size = Profile.Int("ConfigMemorySize")
		
		Progress.ProgressText = "Writing Config Memory"

		PICWriter.LoadDataForProgramMemory 0
		PICWriter.LoadConfiguration
		
		for addr= 0 TO size - 1
			vaddr = addr + org
			Progress.SetBar 0, size - 1, addr
			if not px.Find(vaddr) then			
				PICWriter.command6 BEGIN_ERASE
				Util.Sleep tprog2
				PICWriter.command6 END_PROGRAMMING
			
				data = memory.ReadWord(vaddr)
				
				PICWriter.LoadDataForProgramMemory data
				PICWriter.command6 BEGIN_PROGRAMMING_ONLY
				Util.Sleep 3
				PICWriter.command6 END_PROGRAMMING
			end if
			PICWriter.IncrementAddress
		next
	end sub

	sub InitVars
		memoryUsed = Profile.Int("ProgramMemorySize") - 1
		do while memoryUsed >= 0
			if Memory.GetFlags(memoryUsed * 2) and 1 then
				exit do
			end if
			memoryUsed = memoryUsed - 1
		loop
		memoryUsed = memoryUsed + 1
	end sub

	
	sub Verify
		STDPIC_Reset_PGM
		if not STDPIC_VerifyProgramMemory() then
			exit sub
		end if
		
		STDPIC_Reset_PGM
		if not STDPIC_VerifyDataMemory() then
			exit sub
		end if
		STDPIC_Reset_PGM
		if not STDPIC_VerifyConfigMemory() then
			exit sub
		end if
		
		Progress.ProgressText = "Verify Success"
		MsgBox "Verify success"
	end sub
	
	function PreProgramTest
		dim tmpmem
		
		PreProgramTest = false
		
		set tmpmem = CreateObject("NWriterObjects.HexLoader")
		tmpmem.Allocate(&h2200 * 2)
		
		STDPIC_Reset_PGM
		STDPIC_ReadConfigMemory tmpmem

		if not STDPIC_CheckCPCPD(tmpmem) then
			exit function
		end if
				
		if not STDPIC_CheckDeviceID(tmpmem) then
			exit function
		end if
		
		PreProgramTest = true
	end function
end class


dim pic

set pic = new PIC16F87_88

sub Verify
	pic.InitVars
	pic.Verify
	STDPIC_PowerOff
end sub

sub Read
	pic.InitVars

	STDPIC_Reset_PGM
	STDPIC_ReadProgramMemory Memory
	
	STDPIC_Reset_PGM
	STDPIC_ReadDataMemory Memory
	
	STDPIC_Reset_PGM
	STDPIC_ReadConfigMemory Memory

	STDPIC_PowerOff
end sub

sub Program
	PIC.InitVars
	
	if not PIC.PreProgramTest then
		STDPIC_PowerOff
		exit sub
	end if
	
	STDPIC_Reset_PGM
	PIC.ProgramProgramMemory
	
	STDPIC_Reset_PGM
	PIC.ProgramDataMemory
	
	STDPIC_Reset_PGM
	PIC.ProgramConfigMemory
	STDPIC_PowerOff
end sub

sub ProgramConfigOnly
	PIC.InitVars
	
	if not PIC.PreProgramTest then
		STDPIC_PowerOff
		exit sub
	end if
	
	STDPIC_Reset_PGM
	PIC.ProgramConfigMemory
	STDPIC_PowerOff
end sub

sub VerifyConfigOnly
	PIC.InitVars
	
	STDPIC_Reset_PGM
	STDPIC_VerifyConfigMemory()
	STDPIC_PowerOff
end sub

sub ChipErase
	pic.InitVars
	STDPIC_Reset_PGM
	PICWriter.LoadConfiguration
	PICWriter.Command6 CHIP_ERASE
	STDPIC_PowerOff
end sub

sub Run
	STDPIC_Run
end sub

