option Explicit

' VBScript source code

' XNvgs̃O[o`ς݃IuWFNg
'
' Port IuWFNg
'	C^[ƐڑʐM|[g̃IuWFNg
'	ʏ̓XNvg瑀삵Ȃ
'
' Memory IuWFNg
'	^[QbgɏĂ[f[^̃IuWFNg
'	hext@Cǂݍ܂Ă
'	ʏ̓XNvg瑀삵Ȃ
'	oCgPʂ̃AhbVOs߁APICȂǂł̓AhX2{ėp
' 
' Controller IuWFNg
'	C^[̃|[gRg[sIuWFNg
'	PortIuWFNgA^b`Ă
'
' PICWriter IuWFNg
'	PIC}CȐ݃vgRIuWFNg


' LVP [hł̏s
'
'	MCLR=0, PGM=0
'	MCRL=1, PGM=0
'	MCLR=1, PGM=1
'
sub Reset_LVP()
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 3
	
	Controller.SetLineWait 10
	Controller.PortControl &h01
	
	buf.Rewind
	buf.Add &h00
	buf.Add MCLR
	buf.Add MCLR or PGM
	Controller.LineControl buf, 3
	
end sub

sub Reset_LVP88()
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 3
	
	Controller.SetLineWait 0
	Controller.PortControl &h01
	
	buf.Rewind
	buf.Add &h00
	buf.Add PGM
	buf.Add MCLR or PGM
	Controller.LineControl buf, 3
	
	PICWriter.LoadDataForProgramMemory &h01
end sub

sub Reset_HVP()
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 3
	
	Controller.SetLineWait 10
	Controller.PortControl &h01
	
	buf.Rewind
	buf.Add &h00
	buf.Add CVD
	buf.Add EVL or EVH
	Controller.LineControl buf, 3
	
end sub

sub Reset_Normal()
	dim buf
	
	set buf = CreateObject("NWriterObjects.ByteBuffer")
	buf.allocate 3
	
	Controller.SetLineWait 10
	Controller.PortControl &h01
	
	buf.Rewind
	buf.Add &h00
	Controller.LineControl buf, 3
end sub

sub chiperase
	const CHIP_ERASE = &h1f
	PICWriter.command6 CHIP_ERASE
	util.sleep 8
end sub

dim configInitPC
dim programMemorySize
dim configWordAddress
dim configWordCount
dim memoryUsed

sub ProgramFourWordAlgorthmRow32
	dim endaddr
	dim data
	dim addr
	dim	i
	
	const BEGIN_ERASE = &h08
	const BEGIN_PROGRAMMING_ONLY = &h18
	const END_PROGRAMMING = &h17
	const TPROG2 = 2

	endaddr = cint((memoryUsed + 31) / 32) * 32
	
	addr = 0
	do while addr < endaddr
		PICWriter.command6 BEGIN_ERASE
		Util.Sleep tprog2
		PICWriter.command6 END_PROGRAMMING
		for i = 0 to 31
			data = Util.ReadWord(Memory, addr)
			PICWriter.LoadDataForProgramMemory data
			if (i mod 4) = 3 then
				PICWriter.command6 BEGIN_PROGRAMMING_ONLY
				Util.Sleep 3
				PICWriter.command6 END_PROGRAMMING
			end if
			PICWriter.IncrementAddress
			addr = addr + 1
		next
	loop
end sub

sub ProgramConfigurationWord_88
	dim address
	const BEGIN_PROGRAMMING_ONLY = &h18
	const END_PROGRAMMING = &h17
	const TPROG2 = 2
	
	PICWriter.LoadConfiguration
	
	for address = ConfigInitPC to ConfigWordAddress - 1
		PICWriter.IncrementAddress
	next

	for address = configWordAddress to configWordAddress + configWordCount - 1
		PICWriter.LoadDataForProgramMemory Util.ReadWord(Memory, address)
		
		PICWriter.command6 BEGIN_PROGRAMMING_ONLY
		Util.Sleep 3
		PICWriter.command6 END_PROGRAMMING
		PICWriter.IncrementAddress
	next
end sub


sub ProgramEightWordAlgorthm
	dim address
	dim endaddr
	
	endaddr = cint((memoryUsed + 7) / 8) * 8
	
	for address = 0 to endaddr - 1
		PICWriter.LoadDataForProgramMemory Util.ReadWord(Memory, address)
		if (address mod 8) = 7 then
			PICWriter.BeginProgrammingET
			Util.Sleep 3
			PICWriter.EndProgramming
		end if
		PICWriter.IncrementAddress
	next 
end sub

sub ProgramConfigurationWord
	dim address
	
	PICWriter.LoadConfiguration
	
	for address = ConfigInitPC to ConfigWordAddress - 1
		PICWriter.IncrementAddress
	next

	for address = configWordAddress to configWordAddress + configWordCount - 1
		PICWriter.LoadDataForProgramMemory Util.ReadWord(Memory, address)
		PICWriter.BeginProgrammingET
		Util.Sleep 3
		PICWriter.EndProgramming
		PICWriter.IncrementAddress
	next
end sub

function ReadDeviceID(idpos)
	dim address
	dim r
	
	Reset_LVP
	PICWriter.LoadConfiguration
	
	for address = configInitPC to idpos - 1
		PICWriter.IncrementAddress
	next

	ReadDeviceID = PICWriter.ReadDataFromProgramMemory
	msgbox ReadDeviceID
end function

sub InitVars

	configInitPC = util.ToInteger(profile("ConfigInitPC"))
	configWordAddress = util.ToInteger(profile("ConfigWordAddress"))
	configWordCount = util.ToInteger(profile("ConfigWordCount"))
	programMemorySize = util.ToInteger(profile("ProgramMemorySize"))
	
	memoryUsed = programMemorySize - 1
	do while memoryUsed >= 0
		if Memory.GetFlags(memoryUsed * 2) and 1 then
			exit do
		end if
		memoryUsed = memoryUsed - 1
	loop
	memoryUsed = memoryUsed + 1
	
end sub

function hex4(n)
	hex4 = right("000" & hex(util.tointeger(n)), 4)
end function

function hex2(n)
	hex4 = right("000" & hex(util.tointeger(n)), 4)
end function

sub ProgramA
	
	dim id
	dim idarray

	InitVars

if false then

	idarray = Split(Profile("DeviceID"), ",")
	id = ReadDeviceID(Util.toInteger(idarray(0)))
	if util.toInteger(idarray(1)) <> (id and util.toInteger(idarray(2))) then
		MsgBox "DeviceID Missmatch Expected " & hex4(idarray(1)) & " Detected " & hex4(id)
		exit sub
	end if
end if
	
	dim i
	dim r
	dim s
	
	Reset_LVP
	PICWriter.LoadConfiguration
	
	s = ""
	for i = 0 to 8
		r = PICWriter.ReadDataFromProgramMemory
		s = s & hex4(r) & ":"
		PICWriter.IncrementAddress
	next
	MsgBox s
	exit sub
	
	Reset_LVP
	'PICWriter.BulkEraseProgramMemory
	'chiperase
	'util.sleep 3
	
	Reset_LVP
	ProgramConfigurationWord
	
	Reset_LVP
	ProgramFourWordAlgorthm
	
	Reset_Normal
end sub

sub dump(n)
	dim i
	dim r
	dim s
	
	s = ""
	for i = 0 to n - 1
		r = PICWriter.ReadDataFromProgramMemory
		s = s & hex4(r) & ":"
		PICWriter.IncrementAddress
		if i mod 8 = 7 then
			s = s & chr(13) & chr(10)
		end if
	next
	MsgBox s
end sub

sub IncrementAddress
	const INCREMENT_ADDRESS = &h06
	Writer.Command6 INCREMENT_ADDRESS
end sub

sub Read
	dim addr
	
	InitVars
	Reset_LVP88
	for addr = 0 to programMemorySize - 1
		data = Writer.ReadFromProgramMemory(addr)
		Memory.WriteWord(addr, data)
		IncrementAddress
	next
end sub

function Verify
	dim addr
	
	InitVars
	Reset_LVP88
	for addr = 0 to programMemorySize - 1
		data = Writer.ReadFromProgramMemory(addr)
		if data <> Memory.ReadWord(addr) then
			Verify = false
		end if
		IncrementAddress
	next
end function

sub Program
	InitVars
	Reset_LVP88
	ProgramFourWordAlgorthmRow32
	ProgramConfigurationWord
	Reset_Normal
end sub
