// ComPort.cpp : Implementation of CComPort

#include "stdafx.h"
#include "ComPort.h"


// CComPort

STDMETHODIMP CComPort::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IComPort
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT CComPort::Open(BSTR szDefString)
{
	DCB	dcb;

#ifdef USEOVERLAPPEDIO
	m_hComm = CreateFile(szDefString, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
#else
	m_hComm = CreateFile(szDefString, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
#endif
	if (m_hComm == INVALID_HANDLE_VALUE) {
		return Error("Port could not be opened");
	}

	memset(&dcb, 0, sizeof(dcb));
	dcb.DCBlength = sizeof(dcb);
	
	if (!BuildCommDCB(szDefString, &dcb)) {
		return Error("Port parameter is invalid");
	}
	if (!SetupComm(m_hComm, 1024, 1024)) {
		return Error("Port could not be setup");
	}
	if (!SetCommState(m_hComm, &dcb)) {
		return Error("SetCommState failed");
	}
	if (!SetCommMask(m_hComm, EV_TXEMPTY)) {
		return Error("SetCommMask failed");
	}
	COMMTIMEOUTS ctmo;
	memset(&ctmo, 0, sizeof(ctmo));
	ctmo.ReadTotalTimeoutConstant = 5000;

	if (!SetCommTimeouts(m_hComm, &ctmo)) {
		return Error("SetCommTimeouts failed");
	}
	return S_OK;
}

HRESULT CComPort::Close()
{
	if (m_hComm != INVALID_HANDLE_VALUE)
		CloseHandle(m_hComm);
	return S_OK;
}

HRESULT CComPort::PeekChar(SHORT * c)
{
	HRESULT r;

	if (m_rindex >= m_rlen) {
		r = FillBuf();
		if (FAILED(r))
			return r;
	}
	*c = m_rbuf[m_rindex];
	return S_OK;
}
HRESULT CComPort::ReadChar(SHORT * c)
{
	HRESULT r;

	if (m_rindex >= m_rlen) {
		r = FillBuf();
		if (FAILED(r))
			return r;
	}
	*c = m_rbuf[m_rindex++];
	return S_OK;
}

HRESULT CComPort::WriteChar(SHORT c)
{
	BYTE buf[1];

	buf[0] = (BYTE)c;
	return Write(buf, 1, NULL);
}

HRESULT CComPort::FillBuf()
{
	DWORD	rb;
	COMSTAT	cs;
	DWORD	errors;

	m_rlen = 0;
	m_rindex = 0;

	if (!ClearCommError(m_hComm, &errors, &cs)) {
		return Error("Communication ClearCommError failure");;
	}
	int n;
	n = cs.cbInQue;
	if (n > sizeof(m_rbuf))
		n = sizeof(m_rbuf);
	if (n == 0)
		n++;
	if (!ReadFile(m_hComm, m_rbuf, n, &rb, NULL)) {
		return Error("Communication port read failure");;
	}
	if (rb == 0)
		return Error("Communication port read timeout");
	m_rlen = rb;
	return S_OK;
}

HRESULT CComPort::Read(BYTE * buf, DWORD cbbuf, DWORD * rbytes)
{
	if (!ReadFile(m_hComm, buf, cbbuf, rbytes, NULL)) {
		return Error("WriteFile failed");
	}
	return S_OK;
}

STDMETHODIMP CComPort::WriteString(BSTR strOut)
{
	USES_CONVERSION;
	const char* pstr;
	HRESULT r;

	pstr = OLE2CA(strOut);
	while (*pstr != '\0') {
		r = WriteChar(*pstr & 0xff);
		if (FAILED(r))
			return r;
		pstr++;
	}
	return S_OK;
}

STDMETHODIMP CComPort::Write(BYTE* buf, ULONG size, ULONG* wbytes)
{
	DWORD wb;

	if (!WriteFile(m_hComm, buf, size, &wb, NULL)) {
		return Error("WriteFile failed");
	}
	if (wbytes != NULL)
		*wbytes = wb;
	return S_OK;
}
