// HexLoader.h : Declaration of the CHexLoader

#pragma once
#include "resource.h"       // main symbols

#include "NWriterObjects.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CHexLoader

class ATL_NO_VTABLE CHexLoader :
	public CComObjectRootEx<CComMultiThreadModel>,
	public ISupportErrorInfo,
	public CComCoClass<CHexLoader, &CLSID_HexLoader>,
	public IDispatchImpl<IMemory, &IID_IMemory, &LIBID_NWriterObjectsLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CHexLoader()
	{
		m_memory = NULL;
		m_flags = NULL;
		m_memory_size = 0;
		m_endian = endianLittle;
		m_mask = 0xffffffff;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_HEXLOADER)


BEGIN_COM_MAP(CHexLoader)
	COM_INTERFACE_ENTRY(IMemory)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
		delete m_memory;
		delete m_flags;
	}

public:
	BYTE*	m_memory;
	BYTE*	m_flags;
	ULONG	m_memory_size;
	MEMORYENDIAN	m_endian;

	STDMETHOD(Load)(BSTR FileName, LONG FileType);
	STDMETHOD(Allocate)(ULONG bytes);
	STDMETHOD(ReadByte)(ULONG address, BYTE * rval);
	STDMETHOD(WriteByte)(ULONG address, BYTE val);
	STDMETHOD(GetFlags)(ULONG address, BYTE* pResult);
	STDMETHOD(GetPointer)(BYTE** ppBuffer, BYTE** ppFlags, ULONG* pMemorySize);
	STDMETHOD(WriteWord)(ULONG waddress, long wdata);
	STDMETHOD(ReadWord)(ULONG waddress, long* wdata);
	STDMETHOD(get_Endian)(MEMORYENDIAN* pVal);
	STDMETHOD(put_Endian)(MEMORYENDIAN	newVal);
	STDMETHOD(get_Mask)(long* pVal);
	STDMETHOD(put_Mask)(long newVal);
	long m_mask;
	STDMETHOD(InitNew)(void);
};

OBJECT_ENTRY_AUTO(__uuidof(HexLoader), CHexLoader)
